<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketType StructType
 * @subpackage Structs
 */
class MarketType extends AbstractStructBase
{
    /**
     * The MarketKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MarketKey;
    /**
     * The Export
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Export;
    /**
     * The MarketOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarketOptionsType[]
     */
    public $MarketOptions;
    /**
     * Constructor method for MarketType
     * @uses MarketType::setMarketKey()
     * @uses MarketType::setExport()
     * @uses MarketType::setMarketOptions()
     * @param string $marketKey
     * @param bool $export
     * @param \StructType\MarketOptionsType[] $marketOptions
     */
    public function __construct($marketKey = null, $export = null, array $marketOptions = array())
    {
        $this
            ->setMarketKey($marketKey)
            ->setExport($export)
            ->setMarketOptions($marketOptions);
    }
    /**
     * Get MarketKey value
     * @return string
     */
    public function getMarketKey()
    {
        return $this->MarketKey;
    }
    /**
     * Set MarketKey value
     * @param string $marketKey
     * @return \StructType\MarketType
     */
    public function setMarketKey($marketKey = null)
    {
        // validation for constraint: string
        if (!is_null($marketKey) && !is_string($marketKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketKey)), __LINE__);
        }
        $this->MarketKey = $marketKey;
        return $this;
    }
    /**
     * Get Export value
     * @return bool
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param bool $export
     * @return \StructType\MarketType
     */
    public function setExport($export = null)
    {
        $this->Export = $export;
        return $this;
    }
    /**
     * Get MarketOptions value
     * @return \StructType\MarketOptionsType[]|null
     */
    public function getMarketOptions()
    {
        return $this->MarketOptions;
    }
    /**
     * Set MarketOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketOptionsType[] $marketOptions
     * @return \StructType\MarketType
     */
    public function setMarketOptions(array $marketOptions = array())
    {
        foreach ($marketOptions as $marketTypeMarketOptionsItem) {
            // validation for constraint: itemType
            if (!$marketTypeMarketOptionsItem instanceof \StructType\MarketOptionsType) {
                throw new \InvalidArgumentException(sprintf('The MarketOptions property can only contain items of \StructType\MarketOptionsType, "%s" given', is_object($marketTypeMarketOptionsItem) ? get_class($marketTypeMarketOptionsItem) : gettype($marketTypeMarketOptionsItem)), __LINE__);
            }
        }
        $this->MarketOptions = $marketOptions;
        return $this;
    }
    /**
     * Add item to MarketOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketOptionsType $item
     * @return \StructType\MarketType
     */
    public function addToMarketOptions(\StructType\MarketOptionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketOptionsType) {
            throw new \InvalidArgumentException(sprintf('The MarketOptions property can only contain items of \StructType\MarketOptionsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MarketOptions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MarketType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
