<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketOptionsType StructType
 * @subpackage Structs
 */
class MarketOptionsType extends AbstractStructBase
{
    /**
     * The OptionName
     * @var string
     */
    public $OptionName;
    /**
     * The OptionValue
     * @var string
     */
    public $OptionValue;
    /**
     * Constructor method for MarketOptionsType
     * @uses MarketOptionsType::setOptionName()
     * @uses MarketOptionsType::setOptionValue()
     * @param string $optionName
     * @param string $optionValue
     */
    public function __construct($optionName = null, $optionValue = null)
    {
        $this
            ->setOptionName($optionName)
            ->setOptionValue($optionValue);
    }
    /**
     * Get OptionName value
     * @return string|null
     */
    public function getOptionName()
    {
        return $this->OptionName;
    }
    /**
     * Set OptionName value
     * @param string $optionName
     * @return \StructType\MarketOptionsType
     */
    public function setOptionName($optionName = null)
    {
        // validation for constraint: string
        if (!is_null($optionName) && !is_string($optionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optionName)), __LINE__);
        }
        $this->OptionName = $optionName;
        return $this;
    }
    /**
     * Get OptionValue value
     * @return string|null
     */
    public function getOptionValue()
    {
        return $this->OptionValue;
    }
    /**
     * Set OptionValue value
     * @param string $optionValue
     * @return \StructType\MarketOptionsType
     */
    public function setOptionValue($optionValue = null)
    {
        // validation for constraint: string
        if (!is_null($optionValue) && !is_string($optionValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optionValue)), __LINE__);
        }
        $this->OptionValue = $optionValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MarketOptionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
