<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageType StructType
 * @subpackage Structs
 */
class LanguageType extends AbstractStructBase
{
    /**
     * The ISO6391
     * @var string
     */
    public $ISO6391;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The LocalName
     * @var string
     */
    public $LocalName;
    /**
     * Constructor method for LanguageType
     * @uses LanguageType::setISO6391()
     * @uses LanguageType::setName()
     * @uses LanguageType::setLocalName()
     * @param string $iSO6391
     * @param string $name
     * @param string $localName
     */
    public function __construct($iSO6391 = null, $name = null, $localName = null)
    {
        $this
            ->setISO6391($iSO6391)
            ->setName($name)
            ->setLocalName($localName);
    }
    /**
     * Get ISO6391 value
     * @return string|null
     */
    public function getISO6391()
    {
        return $this->ISO6391;
    }
    /**
     * Set ISO6391 value
     * @param string $iSO6391
     * @return \StructType\LanguageType
     */
    public function setISO6391($iSO6391 = null)
    {
        // validation for constraint: string
        if (!is_null($iSO6391) && !is_string($iSO6391)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSO6391)), __LINE__);
        }
        $this->ISO6391 = $iSO6391;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\LanguageType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get LocalName value
     * @return string|null
     */
    public function getLocalName()
    {
        return $this->LocalName;
    }
    /**
     * Set LocalName value
     * @param string $localName
     * @return \StructType\LanguageType
     */
    public function setLocalName($localName = null)
    {
        // validation for constraint: string
        if (!is_null($localName) && !is_string($localName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localName)), __LINE__);
        }
        $this->LocalName = $localName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LanguageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
