<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InspectionDatesCollection StructType
 * @subpackage Structs
 */
class InspectionDatesCollection extends AbstractStructBase
{
    /**
     * The LastDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastDate;
    /**
     * The LastKm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $LastKm;
    /**
     * The NextDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NextDate;
    /**
     * The NextKm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NextKm;
    /**
     * Constructor method for InspectionDatesCollection
     * @uses InspectionDatesCollection::setLastDate()
     * @uses InspectionDatesCollection::setLastKm()
     * @uses InspectionDatesCollection::setNextDate()
     * @uses InspectionDatesCollection::setNextKm()
     * @param string $lastDate
     * @param int $lastKm
     * @param string $nextDate
     * @param int $nextKm
     */
    public function __construct($lastDate = null, $lastKm = null, $nextDate = null, $nextKm = null)
    {
        $this
            ->setLastDate($lastDate)
            ->setLastKm($lastKm)
            ->setNextDate($nextDate)
            ->setNextKm($nextKm);
    }
    /**
     * Get LastDate value
     * @return string|null
     */
    public function getLastDate()
    {
        return $this->LastDate;
    }
    /**
     * Set LastDate value
     * @param string $lastDate
     * @return \StructType\InspectionDatesCollection
     */
    public function setLastDate($lastDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastDate) && !is_string($lastDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDate)), __LINE__);
        }
        $this->LastDate = $lastDate;
        return $this;
    }
    /**
     * Get LastKm value
     * @return int|null
     */
    public function getLastKm()
    {
        return $this->LastKm;
    }
    /**
     * Set LastKm value
     * @param int $lastKm
     * @return \StructType\InspectionDatesCollection
     */
    public function setLastKm($lastKm = null)
    {
        // validation for constraint: int
        if (!is_null($lastKm) && !is_numeric($lastKm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastKm)), __LINE__);
        }
        $this->LastKm = $lastKm;
        return $this;
    }
    /**
     * Get NextDate value
     * @return string|null
     */
    public function getNextDate()
    {
        return $this->NextDate;
    }
    /**
     * Set NextDate value
     * @param string $nextDate
     * @return \StructType\InspectionDatesCollection
     */
    public function setNextDate($nextDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextDate) && !is_string($nextDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextDate)), __LINE__);
        }
        $this->NextDate = $nextDate;
        return $this;
    }
    /**
     * Get NextKm value
     * @return int|null
     */
    public function getNextKm()
    {
        return $this->NextKm;
    }
    /**
     * Set NextKm value
     * @param int $nextKm
     * @return \StructType\InspectionDatesCollection
     */
    public function setNextKm($nextKm = null)
    {
        // validation for constraint: int
        if (!is_null($nextKm) && !is_numeric($nextKm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nextKm)), __LINE__);
        }
        $this->NextKm = $nextKm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InspectionDatesCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
