<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancingCollection StructType
 * @subpackage Structs
 */
class FinancingCollection extends AbstractStructBase
{
    /**
     * The Bank
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Bank;
    /**
     * The Deposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Deposit;
    /**
     * The Apr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Apr;
    /**
     * The Instalment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Instalment;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The MaxDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxDuration;
    /**
     * The EndingRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EndingRate;
    /**
     * The Beginn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Beginn;
    /**
     * Constructor method for FinancingCollection
     * @uses FinancingCollection::setBank()
     * @uses FinancingCollection::setDeposit()
     * @uses FinancingCollection::setApr()
     * @uses FinancingCollection::setInstalment()
     * @uses FinancingCollection::setDuration()
     * @uses FinancingCollection::setMaxDuration()
     * @uses FinancingCollection::setEndingRate()
     * @uses FinancingCollection::setBeginn()
     * @param string $bank
     * @param float $deposit
     * @param float $apr
     * @param float $instalment
     * @param int $duration
     * @param int $maxDuration
     * @param float $endingRate
     * @param string $beginn
     */
    public function __construct($bank = null, $deposit = null, $apr = null, $instalment = null, $duration = null, $maxDuration = null, $endingRate = null, $beginn = null)
    {
        $this
            ->setBank($bank)
            ->setDeposit($deposit)
            ->setApr($apr)
            ->setInstalment($instalment)
            ->setDuration($duration)
            ->setMaxDuration($maxDuration)
            ->setEndingRate($endingRate)
            ->setBeginn($beginn);
    }
    /**
     * Get Bank value
     * @return string
     */
    public function getBank()
    {
        return $this->Bank;
    }
    /**
     * Set Bank value
     * @param string $bank
     * @return \StructType\FinancingCollection
     */
    public function setBank($bank = null)
    {
        // validation for constraint: string
        if (!is_null($bank) && !is_string($bank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bank)), __LINE__);
        }
        $this->Bank = $bank;
        return $this;
    }
    /**
     * Get Deposit value
     * @return float
     */
    public function getDeposit()
    {
        return $this->Deposit;
    }
    /**
     * Set Deposit value
     * @param float $deposit
     * @return \StructType\FinancingCollection
     */
    public function setDeposit($deposit = null)
    {
        $this->Deposit = $deposit;
        return $this;
    }
    /**
     * Get Apr value
     * @return float
     */
    public function getApr()
    {
        return $this->Apr;
    }
    /**
     * Set Apr value
     * @param float $apr
     * @return \StructType\FinancingCollection
     */
    public function setApr($apr = null)
    {
        $this->Apr = $apr;
        return $this;
    }
    /**
     * Get Instalment value
     * @return float
     */
    public function getInstalment()
    {
        return $this->Instalment;
    }
    /**
     * Set Instalment value
     * @param float $instalment
     * @return \StructType\FinancingCollection
     */
    public function setInstalment($instalment = null)
    {
        $this->Instalment = $instalment;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\FinancingCollection
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get MaxDuration value
     * @return int
     */
    public function getMaxDuration()
    {
        return $this->MaxDuration;
    }
    /**
     * Set MaxDuration value
     * @param int $maxDuration
     * @return \StructType\FinancingCollection
     */
    public function setMaxDuration($maxDuration = null)
    {
        // validation for constraint: int
        if (!is_null($maxDuration) && !is_numeric($maxDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxDuration)), __LINE__);
        }
        $this->MaxDuration = $maxDuration;
        return $this;
    }
    /**
     * Get EndingRate value
     * @return float
     */
    public function getEndingRate()
    {
        return $this->EndingRate;
    }
    /**
     * Set EndingRate value
     * @param float $endingRate
     * @return \StructType\FinancingCollection
     */
    public function setEndingRate($endingRate = null)
    {
        $this->EndingRate = $endingRate;
        return $this;
    }
    /**
     * Get Beginn value
     * @return string
     */
    public function getBeginn()
    {
        return $this->Beginn;
    }
    /**
     * Set Beginn value
     * @param string $beginn
     * @return \StructType\FinancingCollection
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginn)), __LINE__);
        }
        $this->Beginn = $beginn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FinancingCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
