<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FieldsCollection StructType
 * @subpackage Structs
 */
class FieldsCollection extends AbstractStructBase
{
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Field;
    /**
     * Constructor method for FieldsCollection
     * @uses FieldsCollection::setField()
     * @param string[] $field
     */
    public function __construct(array $field = array())
    {
        $this
            ->setField($field);
    }
    /**
     * Get Field value
     * @return string[]|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @throws \InvalidArgumentException
     * @param string[] $field
     * @return \StructType\FieldsCollection
     */
    public function setField(array $field = array())
    {
        foreach ($field as $fieldsCollectionFieldItem) {
            // validation for constraint: itemType
            if (!is_string($fieldsCollectionFieldItem)) {
                throw new \InvalidArgumentException(sprintf('The Field property can only contain items of string, "%s" given', is_object($fieldsCollectionFieldItem) ? get_class($fieldsCollectionFieldItem) : gettype($fieldsCollectionFieldItem)), __LINE__);
            }
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Add item to Field value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\FieldsCollection
     */
    public function addToField($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Field property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Field[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FieldsCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
