<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FieldValues StructType
 * @subpackage Structs
 */
class FieldValues extends AbstractStructBase
{
    /**
     * The Fields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FieldGroupCollection[]
     */
    public $Fields;
    /**
     * Constructor method for FieldValues
     * @uses FieldValues::setFields()
     * @param \StructType\FieldGroupCollection[] $fields
     */
    public function __construct(array $fields = array())
    {
        $this
            ->setFields($fields);
    }
    /**
     * Get Fields value
     * @return \StructType\FieldGroupCollection[]|null
     */
    public function getFields()
    {
        return $this->Fields;
    }
    /**
     * Set Fields value
     * @throws \InvalidArgumentException
     * @param \StructType\FieldGroupCollection[] $fields
     * @return \StructType\FieldValues
     */
    public function setFields(array $fields = array())
    {
        foreach ($fields as $fieldValuesFieldsItem) {
            // validation for constraint: itemType
            if (!$fieldValuesFieldsItem instanceof \StructType\FieldGroupCollection) {
                throw new \InvalidArgumentException(sprintf('The Fields property can only contain items of \StructType\FieldGroupCollection, "%s" given', is_object($fieldValuesFieldsItem) ? get_class($fieldValuesFieldsItem) : gettype($fieldValuesFieldsItem)), __LINE__);
            }
        }
        $this->Fields = $fields;
        return $this;
    }
    /**
     * Add item to Fields value
     * @throws \InvalidArgumentException
     * @param \StructType\FieldGroupCollection $item
     * @return \StructType\FieldValues
     */
    public function addToFields(\StructType\FieldGroupCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FieldGroupCollection) {
            throw new \InvalidArgumentException(sprintf('The Fields property can only contain items of \StructType\FieldGroupCollection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FieldValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
