<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnergyCosts20TKmCollection StructType
 * @subpackage Structs
 */
class EnergyCosts20TKmCollection extends AbstractStructBase
{
    /**
     * The FuelCosts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $FuelCosts;
    /**
     * The FuelPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FuelPrice;
    /**
     * The FuelPriceUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FuelPriceUnit;
    /**
     * The EPowerCosts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $EPowerCosts;
    /**
     * The EPowerPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $EPowerPrice;
    /**
     * Constructor method for EnergyCosts20TKmCollection
     * @uses EnergyCosts20TKmCollection::setFuelCosts()
     * @uses EnergyCosts20TKmCollection::setFuelPrice()
     * @uses EnergyCosts20TKmCollection::setFuelPriceUnit()
     * @uses EnergyCosts20TKmCollection::setEPowerCosts()
     * @uses EnergyCosts20TKmCollection::setEPowerPrice()
     * @param float $fuelCosts
     * @param float $fuelPrice
     * @param int $fuelPriceUnit
     * @param float $ePowerCosts
     * @param float $ePowerPrice
     */
    public function __construct($fuelCosts = null, $fuelPrice = null, $fuelPriceUnit = null, $ePowerCosts = null, $ePowerPrice = null)
    {
        $this
            ->setFuelCosts($fuelCosts)
            ->setFuelPrice($fuelPrice)
            ->setFuelPriceUnit($fuelPriceUnit)
            ->setEPowerCosts($ePowerCosts)
            ->setEPowerPrice($ePowerPrice);
    }
    /**
     * Get FuelCosts value
     * @return float|null
     */
    public function getFuelCosts()
    {
        return $this->FuelCosts;
    }
    /**
     * Set FuelCosts value
     * @param float $fuelCosts
     * @return \StructType\EnergyCosts20TKmCollection
     */
    public function setFuelCosts($fuelCosts = null)
    {
        $this->FuelCosts = $fuelCosts;
        return $this;
    }
    /**
     * Get FuelPrice value
     * @return float|null
     */
    public function getFuelPrice()
    {
        return $this->FuelPrice;
    }
    /**
     * Set FuelPrice value
     * @param float $fuelPrice
     * @return \StructType\EnergyCosts20TKmCollection
     */
    public function setFuelPrice($fuelPrice = null)
    {
        $this->FuelPrice = $fuelPrice;
        return $this;
    }
    /**
     * Get FuelPriceUnit value
     * @return int|null
     */
    public function getFuelPriceUnit()
    {
        return $this->FuelPriceUnit;
    }
    /**
     * Set FuelPriceUnit value
     * @param int $fuelPriceUnit
     * @return \StructType\EnergyCosts20TKmCollection
     */
    public function setFuelPriceUnit($fuelPriceUnit = null)
    {
        // validation for constraint: int
        if (!is_null($fuelPriceUnit) && !is_numeric($fuelPriceUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelPriceUnit)), __LINE__);
        }
        $this->FuelPriceUnit = $fuelPriceUnit;
        return $this;
    }
    /**
     * Get EPowerCosts value
     * @return float|null
     */
    public function getEPowerCosts()
    {
        return $this->EPowerCosts;
    }
    /**
     * Set EPowerCosts value
     * @param float $ePowerCosts
     * @return \StructType\EnergyCosts20TKmCollection
     */
    public function setEPowerCosts($ePowerCosts = null)
    {
        $this->EPowerCosts = $ePowerCosts;
        return $this;
    }
    /**
     * Get EPowerPrice value
     * @return float|null
     */
    public function getEPowerPrice()
    {
        return $this->EPowerPrice;
    }
    /**
     * Set EPowerPrice value
     * @param float $ePowerPrice
     * @return \StructType\EnergyCosts20TKmCollection
     */
    public function setEPowerPrice($ePowerPrice = null)
    {
        $this->EPowerPrice = $ePowerPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnergyCosts20TKmCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
