<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ColorCollection StructType
 * @subpackage Structs
 */
class ColorCollection extends AbstractStructBase
{
    /**
     * The External
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $External;
    /**
     * The Metalic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Metalic;
    /**
     * The Producer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Producer;
    /**
     * The Interior
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Interior;
    /**
     * The Upholstery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Upholstery;
    /**
     * Constructor method for ColorCollection
     * @uses ColorCollection::setExternal()
     * @uses ColorCollection::setMetalic()
     * @uses ColorCollection::setProducer()
     * @uses ColorCollection::setInterior()
     * @uses ColorCollection::setUpholstery()
     * @param int $external
     * @param bool $metalic
     * @param string $producer
     * @param int $interior
     * @param int $upholstery
     */
    public function __construct($external = null, $metalic = null, $producer = null, $interior = null, $upholstery = null)
    {
        $this
            ->setExternal($external)
            ->setMetalic($metalic)
            ->setProducer($producer)
            ->setInterior($interior)
            ->setUpholstery($upholstery);
    }
    /**
     * Get External value
     * @return int|null
     */
    public function getExternal()
    {
        return $this->External;
    }
    /**
     * Set External value
     * @param int $external
     * @return \StructType\ColorCollection
     */
    public function setExternal($external = null)
    {
        // validation for constraint: int
        if (!is_null($external) && !is_numeric($external)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($external)), __LINE__);
        }
        $this->External = $external;
        return $this;
    }
    /**
     * Get Metalic value
     * @return bool|null
     */
    public function getMetalic()
    {
        return $this->Metalic;
    }
    /**
     * Set Metalic value
     * @param bool $metalic
     * @return \StructType\ColorCollection
     */
    public function setMetalic($metalic = null)
    {
        $this->Metalic = $metalic;
        return $this;
    }
    /**
     * Get Producer value
     * @return string|null
     */
    public function getProducer()
    {
        return $this->Producer;
    }
    /**
     * Set Producer value
     * @param string $producer
     * @return \StructType\ColorCollection
     */
    public function setProducer($producer = null)
    {
        // validation for constraint: string
        if (!is_null($producer) && !is_string($producer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($producer)), __LINE__);
        }
        $this->Producer = $producer;
        return $this;
    }
    /**
     * Get Interior value
     * @return int|null
     */
    public function getInterior()
    {
        return $this->Interior;
    }
    /**
     * Set Interior value
     * @param int $interior
     * @return \StructType\ColorCollection
     */
    public function setInterior($interior = null)
    {
        // validation for constraint: int
        if (!is_null($interior) && !is_numeric($interior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interior)), __LINE__);
        }
        $this->Interior = $interior;
        return $this;
    }
    /**
     * Get Upholstery value
     * @return int|null
     */
    public function getUpholstery()
    {
        return $this->Upholstery;
    }
    /**
     * Set Upholstery value
     * @param int $upholstery
     * @return \StructType\ColorCollection
     */
    public function setUpholstery($upholstery = null)
    {
        // validation for constraint: int
        if (!is_null($upholstery) && !is_numeric($upholstery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($upholstery)), __LINE__);
        }
        $this->Upholstery = $upholstery;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ColorCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
