<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccsListCollection StructType
 * @subpackage Structs
 */
class AccsListCollection extends AbstractStructBase
{
    /**
     * The Accs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccsType[]
     */
    public $Accs;
    /**
     * Constructor method for AccsListCollection
     * @uses AccsListCollection::setAccs()
     * @param \StructType\AccsType[] $accs
     */
    public function __construct(array $accs = array())
    {
        $this
            ->setAccs($accs);
    }
    /**
     * Get Accs value
     * @return \StructType\AccsType[]|null
     */
    public function getAccs()
    {
        return $this->Accs;
    }
    /**
     * Set Accs value
     * @throws \InvalidArgumentException
     * @param \StructType\AccsType[] $accs
     * @return \StructType\AccsListCollection
     */
    public function setAccs(array $accs = array())
    {
        foreach ($accs as $accsListCollectionAccsItem) {
            // validation for constraint: itemType
            if (!$accsListCollectionAccsItem instanceof \StructType\AccsType) {
                throw new \InvalidArgumentException(sprintf('The Accs property can only contain items of \StructType\AccsType, "%s" given', is_object($accsListCollectionAccsItem) ? get_class($accsListCollectionAccsItem) : gettype($accsListCollectionAccsItem)), __LINE__);
            }
        }
        $this->Accs = $accs;
        return $this;
    }
    /**
     * Add item to Accs value
     * @throws \InvalidArgumentException
     * @param \StructType\AccsType $item
     * @return \StructType\AccsListCollection
     */
    public function addToAccs(\StructType\AccsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccsType) {
            throw new \InvalidArgumentException(sprintf('The Accs property can only contain items of \StructType\AccsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Accs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccsListCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
