<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCosts ArrayType
 * @subpackage Arrays
 */
class ArrayOfCosts extends AbstractStructArrayBase
{
    /**
     * The Costs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CostsCollection[]
     */
    public $Costs;
    /**
     * Constructor method for ArrayOfCosts
     * @uses ArrayOfCosts::setCosts()
     * @param \StructType\CostsCollection[] $costs
     */
    public function __construct(array $costs = array())
    {
        $this
            ->setCosts($costs);
    }
    /**
     * Get Costs value
     * @return \StructType\CostsCollection[]|null
     */
    public function getCosts()
    {
        return $this->Costs;
    }
    /**
     * Set Costs value
     * @throws \InvalidArgumentException
     * @param \StructType\CostsCollection[] $costs
     * @return \ArrayType\ArrayOfCosts
     */
    public function setCosts(array $costs = array())
    {
        foreach ($costs as $arrayOfCostsCostsItem) {
            // validation for constraint: itemType
            if (!$arrayOfCostsCostsItem instanceof \StructType\CostsCollection) {
                throw new \InvalidArgumentException(sprintf('The Costs property can only contain items of \StructType\CostsCollection, "%s" given', is_object($arrayOfCostsCostsItem) ? get_class($arrayOfCostsCostsItem) : gettype($arrayOfCostsCostsItem)), __LINE__);
            }
        }
        $this->Costs = $costs;
        return $this;
    }
    /**
     * Add item to Costs value
     * @throws \InvalidArgumentException
     * @param \StructType\CostsCollection $item
     * @return \ArrayType\ArrayOfCosts
     */
    public function addToCosts(\StructType\CostsCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CostsCollection) {
            throw new \InvalidArgumentException(sprintf('The Costs property can only contain items of \StructType\CostsCollection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Costs[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CostsCollection|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CostsCollection|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CostsCollection|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CostsCollection|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CostsCollection|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Costs
     */
    public function getAttributeName()
    {
        return 'Costs';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCosts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
