<?php

namespace Stellae\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfcatalog_item ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfcatalog_item
 * @subpackage Arrays
 */
class ArrayOfcatalog_item extends AbstractStructArrayBase
{
    /**
     * The catalog_item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stellae\StructType\Catalog_item[]
     */
    public $catalog_item;
    /**
     * Constructor method for ArrayOfcatalog_item
     * @uses ArrayOfcatalog_item::setCatalog_item()
     * @param \Stellae\StructType\Catalog_item[] $catalog_item
     */
    public function __construct(array $catalog_item = array())
    {
        $this
            ->setCatalog_item($catalog_item);
    }
    /**
     * Get catalog_item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stellae\StructType\Catalog_item[]|null
     */
    public function getCatalog_item()
    {
        return isset($this->catalog_item) ? $this->catalog_item : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_item method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_item method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_itemForArrayConstraintsFromSetCatalog_item(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfcatalog_itemCatalog_itemItem) {
            // validation for constraint: itemType
            if (!$arrayOfcatalog_itemCatalog_itemItem instanceof \Stellae\StructType\Catalog_item) {
                $invalidValues[] = is_object($arrayOfcatalog_itemCatalog_itemItem) ? get_class($arrayOfcatalog_itemCatalog_itemItem) : sprintf('%s(%s)', gettype($arrayOfcatalog_itemCatalog_itemItem), var_export($arrayOfcatalog_itemCatalog_itemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The catalog_item property can only contain items of type \Stellae\StructType\Catalog_item, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set catalog_item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Stellae\StructType\Catalog_item[] $catalog_item
     * @return \Stellae\ArrayType\ArrayOfcatalog_item
     */
    public function setCatalog_item(array $catalog_item = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_itemArrayErrorMessage = self::validateCatalog_itemForArrayConstraintsFromSetCatalog_item($catalog_item))) {
            throw new \InvalidArgumentException($catalog_itemArrayErrorMessage, __LINE__);
        }
        if (is_null($catalog_item) || (is_array($catalog_item) && empty($catalog_item))) {
            unset($this->catalog_item);
        } else {
            $this->catalog_item = $catalog_item;
        }
        return $this;
    }
    /**
     * Add item to catalog_item value
     * @throws \InvalidArgumentException
     * @param \Stellae\StructType\Catalog_item $item
     * @return \Stellae\ArrayType\ArrayOfcatalog_item
     */
    public function addToCatalog_item(\Stellae\StructType\Catalog_item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Stellae\StructType\Catalog_item) {
            throw new \InvalidArgumentException(sprintf('The catalog_item property can only contain items of type \Stellae\StructType\Catalog_item, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->catalog_item[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stellae\StructType\Catalog_item|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stellae\StructType\Catalog_item|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stellae\StructType\Catalog_item|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stellae\StructType\Catalog_item|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stellae\StructType\Catalog_item|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string catalog_item
     */
    public function getAttributeName()
    {
        return 'catalog_item';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\ArrayType\ArrayOfcatalog_item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
