<?php

namespace Stellae\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPC_Inventory_Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UPC_Inventory_Response
 * @subpackage Structs
 */
class UPC_Inventory_Response extends AbstractStructBase
{
    /**
     * The lot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $lot;
    /**
     * The on_hand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $on_hand;
    /**
     * The uom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uom;
    /**
     * The upc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $upc;
    /**
     * The warehouse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $warehouse;
    /**
     * Constructor method for UPC_Inventory_Response
     * @uses UPC_Inventory_Response::setLot()
     * @uses UPC_Inventory_Response::setOn_hand()
     * @uses UPC_Inventory_Response::setUom()
     * @uses UPC_Inventory_Response::setUpc()
     * @uses UPC_Inventory_Response::setWarehouse()
     * @param string $lot
     * @param float $on_hand
     * @param string $uom
     * @param string $upc
     * @param string $warehouse
     */
    public function __construct($lot = null, $on_hand = null, $uom = null, $upc = null, $warehouse = null)
    {
        $this
            ->setLot($lot)
            ->setOn_hand($on_hand)
            ->setUom($uom)
            ->setUpc($upc)
            ->setWarehouse($warehouse);
    }
    /**
     * Get lot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLot()
    {
        return isset($this->lot) ? $this->lot : null;
    }
    /**
     * Set lot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lot
     * @return \Stellae\StructType\UPC_Inventory_Response
     */
    public function setLot($lot = null)
    {
        // validation for constraint: string
        if (!is_null($lot) && !is_string($lot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lot, true), gettype($lot)), __LINE__);
        }
        if (is_null($lot) || (is_array($lot) && empty($lot))) {
            unset($this->lot);
        } else {
            $this->lot = $lot;
        }
        return $this;
    }
    /**
     * Get on_hand value
     * @return float|null
     */
    public function getOn_hand()
    {
        return $this->on_hand;
    }
    /**
     * Set on_hand value
     * @param float $on_hand
     * @return \Stellae\StructType\UPC_Inventory_Response
     */
    public function setOn_hand($on_hand = null)
    {
        // validation for constraint: float
        if (!is_null($on_hand) && !(is_float($on_hand) || is_numeric($on_hand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($on_hand, true), gettype($on_hand)), __LINE__);
        }
        $this->on_hand = $on_hand;
        return $this;
    }
    /**
     * Get uom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUom()
    {
        return isset($this->uom) ? $this->uom : null;
    }
    /**
     * Set uom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uom
     * @return \Stellae\StructType\UPC_Inventory_Response
     */
    public function setUom($uom = null)
    {
        // validation for constraint: string
        if (!is_null($uom) && !is_string($uom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uom, true), gettype($uom)), __LINE__);
        }
        if (is_null($uom) || (is_array($uom) && empty($uom))) {
            unset($this->uom);
        } else {
            $this->uom = $uom;
        }
        return $this;
    }
    /**
     * Get upc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpc()
    {
        return isset($this->upc) ? $this->upc : null;
    }
    /**
     * Set upc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $upc
     * @return \Stellae\StructType\UPC_Inventory_Response
     */
    public function setUpc($upc = null)
    {
        // validation for constraint: string
        if (!is_null($upc) && !is_string($upc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upc, true), gettype($upc)), __LINE__);
        }
        if (is_null($upc) || (is_array($upc) && empty($upc))) {
            unset($this->upc);
        } else {
            $this->upc = $upc;
        }
        return $this;
    }
    /**
     * Get warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouse()
    {
        return isset($this->warehouse) ? $this->warehouse : null;
    }
    /**
     * Set warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouse
     * @return \Stellae\StructType\UPC_Inventory_Response
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: string
        if (!is_null($warehouse) && !is_string($warehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouse, true), gettype($warehouse)), __LINE__);
        }
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->warehouse);
        } else {
            $this->warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\StructType\UPC_Inventory_Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
