<?php

namespace Stellae\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPC_Inventory_Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UPC_Inventory_Request
 * @subpackage Structs
 */
class UPC_Inventory_Request extends AbstractStructBase
{
    /**
     * The upc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $upc;
    /**
     * The warehouse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $warehouse;
    /**
     * Constructor method for UPC_Inventory_Request
     * @uses UPC_Inventory_Request::setUpc()
     * @uses UPC_Inventory_Request::setWarehouse()
     * @param string $upc
     * @param string $warehouse
     */
    public function __construct($upc = null, $warehouse = null)
    {
        $this
            ->setUpc($upc)
            ->setWarehouse($warehouse);
    }
    /**
     * Get upc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpc()
    {
        return isset($this->upc) ? $this->upc : null;
    }
    /**
     * Set upc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $upc
     * @return \Stellae\StructType\UPC_Inventory_Request
     */
    public function setUpc($upc = null)
    {
        // validation for constraint: string
        if (!is_null($upc) && !is_string($upc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upc, true), gettype($upc)), __LINE__);
        }
        if (is_null($upc) || (is_array($upc) && empty($upc))) {
            unset($this->upc);
        } else {
            $this->upc = $upc;
        }
        return $this;
    }
    /**
     * Get warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouse()
    {
        return isset($this->warehouse) ? $this->warehouse : null;
    }
    /**
     * Set warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouse
     * @return \Stellae\StructType\UPC_Inventory_Request
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: string
        if (!is_null($warehouse) && !is_string($warehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouse, true), gettype($warehouse)), __LINE__);
        }
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->warehouse);
        } else {
            $this->warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\StructType\UPC_Inventory_Request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
