<?php

namespace Stellae\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewOrderRequestResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NewOrderRequestResponse
 * @subpackage Structs
 */
class NewOrderRequestResponse extends AbstractStructBase
{
    /**
     * The detail_status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Stellae\ArrayType\ArrayOfstring
     */
    public $detail_status;
    /**
     * The sii_order_number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sii_order_number;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * Constructor method for NewOrderRequestResponse
     * @uses NewOrderRequestResponse::setDetail_status()
     * @uses NewOrderRequestResponse::setSii_order_number()
     * @uses NewOrderRequestResponse::setStatus()
     * @param \Stellae\ArrayType\ArrayOfstring $detail_status
     * @param float $sii_order_number
     * @param string $status
     */
    public function __construct(\Stellae\ArrayType\ArrayOfstring $detail_status = null, $sii_order_number = null, $status = null)
    {
        $this
            ->setDetail_status($detail_status)
            ->setSii_order_number($sii_order_number)
            ->setStatus($status);
    }
    /**
     * Get detail_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stellae\ArrayType\ArrayOfstring|null
     */
    public function getDetail_status()
    {
        return isset($this->detail_status) ? $this->detail_status : null;
    }
    /**
     * Set detail_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stellae\ArrayType\ArrayOfstring $detail_status
     * @return \Stellae\StructType\NewOrderRequestResponse
     */
    public function setDetail_status(\Stellae\ArrayType\ArrayOfstring $detail_status = null)
    {
        if (is_null($detail_status) || (is_array($detail_status) && empty($detail_status))) {
            unset($this->detail_status);
        } else {
            $this->detail_status = $detail_status;
        }
        return $this;
    }
    /**
     * Get sii_order_number value
     * @return float|null
     */
    public function getSii_order_number()
    {
        return $this->sii_order_number;
    }
    /**
     * Set sii_order_number value
     * @param float $sii_order_number
     * @return \Stellae\StructType\NewOrderRequestResponse
     */
    public function setSii_order_number($sii_order_number = null)
    {
        // validation for constraint: float
        if (!is_null($sii_order_number) && !(is_float($sii_order_number) || is_numeric($sii_order_number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sii_order_number, true), gettype($sii_order_number)), __LINE__);
        }
        $this->sii_order_number = $sii_order_number;
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \Stellae\StructType\NewOrderRequestResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\StructType\NewOrderRequestResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
