<?php

namespace Stellae\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Orderstatus ServiceType
 * @subpackage Services
 */
class Orderstatus extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named order_status
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stellae\StructType\Order_status $parameters
     * @return \Stellae\StructType\Order_statusResponse|bool
     */
    public function order_status(\Stellae\StructType\Order_status $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->order_status($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stellae\StructType\Order_statusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
