<?php

namespace Stellae\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Newasnentry ServiceType
 * @subpackage Services
 */
class Newasnentry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named new_asn_entry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stellae\StructType\New_asn_entry $parameters
     * @return \Stellae\StructType\New_asn_entryResponse|bool
     */
    public function new_asn_entry(\Stellae\StructType\New_asn_entry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->new_asn_entry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stellae\StructType\New_asn_entryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
