<?php

namespace Stellae\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Importlinelist ServiceType
 * @subpackage Services
 */
class Importlinelist extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named import_line_list
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stellae\StructType\Import_line_list $parameters
     * @return \Stellae\StructType\Import_line_listResponse|bool
     */
    public function import_line_list(\Stellae\StructType\Import_line_list $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->import_line_list($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stellae\StructType\Import_line_listResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
