<?php

namespace Stellae\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfshipment_status ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfshipment_status
 * @subpackage Arrays
 */
class ArrayOfshipment_status extends AbstractStructArrayBase
{
    /**
     * The shipment_status
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stellae\StructType\Shipment_status[]
     */
    public $shipment_status;
    /**
     * Constructor method for ArrayOfshipment_status
     * @uses ArrayOfshipment_status::setShipment_status()
     * @param \Stellae\StructType\Shipment_status[] $shipment_status
     */
    public function __construct(array $shipment_status = array())
    {
        $this
            ->setShipment_status($shipment_status);
    }
    /**
     * Get shipment_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stellae\StructType\Shipment_status[]|null
     */
    public function getShipment_status()
    {
        return isset($this->shipment_status) ? $this->shipment_status : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipment_status method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipment_status method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipment_statusForArrayConstraintsFromSetShipment_status(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfshipment_statusShipment_statusItem) {
            // validation for constraint: itemType
            if (!$arrayOfshipment_statusShipment_statusItem instanceof \Stellae\StructType\Shipment_status) {
                $invalidValues[] = is_object($arrayOfshipment_statusShipment_statusItem) ? get_class($arrayOfshipment_statusShipment_statusItem) : sprintf('%s(%s)', gettype($arrayOfshipment_statusShipment_statusItem), var_export($arrayOfshipment_statusShipment_statusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipment_status property can only contain items of type \Stellae\StructType\Shipment_status, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipment_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Stellae\StructType\Shipment_status[] $shipment_status
     * @return \Stellae\ArrayType\ArrayOfshipment_status
     */
    public function setShipment_status(array $shipment_status = array())
    {
        // validation for constraint: array
        if ('' !== ($shipment_statusArrayErrorMessage = self::validateShipment_statusForArrayConstraintsFromSetShipment_status($shipment_status))) {
            throw new \InvalidArgumentException($shipment_statusArrayErrorMessage, __LINE__);
        }
        if (is_null($shipment_status) || (is_array($shipment_status) && empty($shipment_status))) {
            unset($this->shipment_status);
        } else {
            $this->shipment_status = $shipment_status;
        }
        return $this;
    }
    /**
     * Add item to shipment_status value
     * @throws \InvalidArgumentException
     * @param \Stellae\StructType\Shipment_status $item
     * @return \Stellae\ArrayType\ArrayOfshipment_status
     */
    public function addToShipment_status(\Stellae\StructType\Shipment_status $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Stellae\StructType\Shipment_status) {
            throw new \InvalidArgumentException(sprintf('The shipment_status property can only contain items of type \Stellae\StructType\Shipment_status, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipment_status[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stellae\StructType\Shipment_status|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stellae\StructType\Shipment_status|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stellae\StructType\Shipment_status|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stellae\StructType\Shipment_status|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stellae\StructType\Shipment_status|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string shipment_status
     */
    public function getAttributeName()
    {
        return 'shipment_status';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\ArrayType\ArrayOfshipment_status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
