<?php

namespace Stellae\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment_Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Shipment_Request
 * @subpackage Structs
 */
class Shipment_Request extends AbstractStructBase
{
    /**
     * The CUSTOMER_CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CUSTOMER_CODE;
    /**
     * The FLAGS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FLAGS;
    /**
     * The date_from
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date_from;
    /**
     * The date_to
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date_to;
    /**
     * The order_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $order_id;
    /**
     * Constructor method for Shipment_Request
     * @uses Shipment_Request::setCUSTOMER_CODE()
     * @uses Shipment_Request::setFLAGS()
     * @uses Shipment_Request::setDate_from()
     * @uses Shipment_Request::setDate_to()
     * @uses Shipment_Request::setOrder_id()
     * @param string $cUSTOMER_CODE
     * @param string $fLAGS
     * @param string $date_from
     * @param string $date_to
     * @param string $order_id
     */
    public function __construct($cUSTOMER_CODE = null, $fLAGS = null, $date_from = null, $date_to = null, $order_id = null)
    {
        $this
            ->setCUSTOMER_CODE($cUSTOMER_CODE)
            ->setFLAGS($fLAGS)
            ->setDate_from($date_from)
            ->setDate_to($date_to)
            ->setOrder_id($order_id);
    }
    /**
     * Get CUSTOMER_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_CODE()
    {
        return isset($this->CUSTOMER_CODE) ? $this->CUSTOMER_CODE : null;
    }
    /**
     * Set CUSTOMER_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_CODE
     * @return \Stellae\StructType\Shipment_Request
     */
    public function setCUSTOMER_CODE($cUSTOMER_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMER_CODE) && !is_string($cUSTOMER_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUSTOMER_CODE, true), gettype($cUSTOMER_CODE)), __LINE__);
        }
        if (is_null($cUSTOMER_CODE) || (is_array($cUSTOMER_CODE) && empty($cUSTOMER_CODE))) {
            unset($this->CUSTOMER_CODE);
        } else {
            $this->CUSTOMER_CODE = $cUSTOMER_CODE;
        }
        return $this;
    }
    /**
     * Get FLAGS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFLAGS()
    {
        return isset($this->FLAGS) ? $this->FLAGS : null;
    }
    /**
     * Set FLAGS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fLAGS
     * @return \Stellae\StructType\Shipment_Request
     */
    public function setFLAGS($fLAGS = null)
    {
        // validation for constraint: string
        if (!is_null($fLAGS) && !is_string($fLAGS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fLAGS, true), gettype($fLAGS)), __LINE__);
        }
        if (is_null($fLAGS) || (is_array($fLAGS) && empty($fLAGS))) {
            unset($this->FLAGS);
        } else {
            $this->FLAGS = $fLAGS;
        }
        return $this;
    }
    /**
     * Get date_from value
     * @return string|null
     */
    public function getDate_from()
    {
        return $this->date_from;
    }
    /**
     * Set date_from value
     * @param string $date_from
     * @return \Stellae\StructType\Shipment_Request
     */
    public function setDate_from($date_from = null)
    {
        // validation for constraint: string
        if (!is_null($date_from) && !is_string($date_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_from, true), gettype($date_from)), __LINE__);
        }
        $this->date_from = $date_from;
        return $this;
    }
    /**
     * Get date_to value
     * @return string|null
     */
    public function getDate_to()
    {
        return $this->date_to;
    }
    /**
     * Set date_to value
     * @param string $date_to
     * @return \Stellae\StructType\Shipment_Request
     */
    public function setDate_to($date_to = null)
    {
        // validation for constraint: string
        if (!is_null($date_to) && !is_string($date_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_to, true), gettype($date_to)), __LINE__);
        }
        $this->date_to = $date_to;
        return $this;
    }
    /**
     * Get order_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrder_id()
    {
        return isset($this->order_id) ? $this->order_id : null;
    }
    /**
     * Set order_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $order_id
     * @return \Stellae\StructType\Shipment_Request
     */
    public function setOrder_id($order_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_id) && !is_string($order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order_id, true), gettype($order_id)), __LINE__);
        }
        if (is_null($order_id) || (is_array($order_id) && empty($order_id))) {
            unset($this->order_id);
        } else {
            $this->order_id = $order_id;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\StructType\Shipment_Request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
