<?php

namespace Stellae\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestResponse
 * @subpackage Structs
 */
class RequestResponse extends AbstractStructBase
{
    /**
     * The Inventory_values
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Stellae\ArrayType\ArrayOfUPC_Inventory_Response
     */
    public $Inventory_values;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * Constructor method for RequestResponse
     * @uses RequestResponse::setInventory_values()
     * @uses RequestResponse::setStatus()
     * @param \Stellae\ArrayType\ArrayOfUPC_Inventory_Response $inventory_values
     * @param string $status
     */
    public function __construct(\Stellae\ArrayType\ArrayOfUPC_Inventory_Response $inventory_values = null, $status = null)
    {
        $this
            ->setInventory_values($inventory_values)
            ->setStatus($status);
    }
    /**
     * Get Inventory_values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stellae\ArrayType\ArrayOfUPC_Inventory_Response|null
     */
    public function getInventory_values()
    {
        return isset($this->Inventory_values) ? $this->Inventory_values : null;
    }
    /**
     * Set Inventory_values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stellae\ArrayType\ArrayOfUPC_Inventory_Response $inventory_values
     * @return \Stellae\StructType\RequestResponse
     */
    public function setInventory_values(\Stellae\ArrayType\ArrayOfUPC_Inventory_Response $inventory_values = null)
    {
        if (is_null($inventory_values) || (is_array($inventory_values) && empty($inventory_values))) {
            unset($this->Inventory_values);
        } else {
            $this->Inventory_values = $inventory_values;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \Stellae\StructType\RequestResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\StructType\RequestResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
