<?php

namespace Stellae\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfinvoice_line ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfinvoice_line
 * @subpackage Arrays
 */
class ArrayOfinvoice_line extends AbstractStructArrayBase
{
    /**
     * The invoice_line
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stellae\StructType\Invoice_line[]
     */
    public $invoice_line;
    /**
     * Constructor method for ArrayOfinvoice_line
     * @uses ArrayOfinvoice_line::setInvoice_line()
     * @param \Stellae\StructType\Invoice_line[] $invoice_line
     */
    public function __construct(array $invoice_line = array())
    {
        $this
            ->setInvoice_line($invoice_line);
    }
    /**
     * Get invoice_line value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stellae\StructType\Invoice_line[]|null
     */
    public function getInvoice_line()
    {
        return isset($this->invoice_line) ? $this->invoice_line : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice_line method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice_line method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoice_lineForArrayConstraintsFromSetInvoice_line(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfinvoice_lineInvoice_lineItem) {
            // validation for constraint: itemType
            if (!$arrayOfinvoice_lineInvoice_lineItem instanceof \Stellae\StructType\Invoice_line) {
                $invalidValues[] = is_object($arrayOfinvoice_lineInvoice_lineItem) ? get_class($arrayOfinvoice_lineInvoice_lineItem) : sprintf('%s(%s)', gettype($arrayOfinvoice_lineInvoice_lineItem), var_export($arrayOfinvoice_lineInvoice_lineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The invoice_line property can only contain items of type \Stellae\StructType\Invoice_line, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set invoice_line value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Stellae\StructType\Invoice_line[] $invoice_line
     * @return \Stellae\ArrayType\ArrayOfinvoice_line
     */
    public function setInvoice_line(array $invoice_line = array())
    {
        // validation for constraint: array
        if ('' !== ($invoice_lineArrayErrorMessage = self::validateInvoice_lineForArrayConstraintsFromSetInvoice_line($invoice_line))) {
            throw new \InvalidArgumentException($invoice_lineArrayErrorMessage, __LINE__);
        }
        if (is_null($invoice_line) || (is_array($invoice_line) && empty($invoice_line))) {
            unset($this->invoice_line);
        } else {
            $this->invoice_line = $invoice_line;
        }
        return $this;
    }
    /**
     * Add item to invoice_line value
     * @throws \InvalidArgumentException
     * @param \Stellae\StructType\Invoice_line $item
     * @return \Stellae\ArrayType\ArrayOfinvoice_line
     */
    public function addToInvoice_line(\Stellae\StructType\Invoice_line $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Stellae\StructType\Invoice_line) {
            throw new \InvalidArgumentException(sprintf('The invoice_line property can only contain items of type \Stellae\StructType\Invoice_line, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->invoice_line[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stellae\StructType\Invoice_line|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stellae\StructType\Invoice_line|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stellae\StructType\Invoice_line|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stellae\StructType\Invoice_line|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stellae\StructType\Invoice_line|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string invoice_line
     */
    public function getAttributeName()
    {
        return 'invoice_line';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\ArrayType\ArrayOfinvoice_line
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
