<?php

namespace Stellae\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPurchase_Order_Receipt_Item ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPurchase_Order_Receipt_Item
 * @subpackage Arrays
 */
class ArrayOfPurchase_Order_Receipt_Item extends AbstractStructArrayBase
{
    /**
     * The Purchase_Order_Receipt_Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stellae\StructType\Purchase_Order_Receipt_Item[]
     */
    public $Purchase_Order_Receipt_Item;
    /**
     * Constructor method for ArrayOfPurchase_Order_Receipt_Item
     * @uses ArrayOfPurchase_Order_Receipt_Item::setPurchase_Order_Receipt_Item()
     * @param \Stellae\StructType\Purchase_Order_Receipt_Item[] $purchase_Order_Receipt_Item
     */
    public function __construct(array $purchase_Order_Receipt_Item = array())
    {
        $this
            ->setPurchase_Order_Receipt_Item($purchase_Order_Receipt_Item);
    }
    /**
     * Get Purchase_Order_Receipt_Item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stellae\StructType\Purchase_Order_Receipt_Item[]|null
     */
    public function getPurchase_Order_Receipt_Item()
    {
        return isset($this->Purchase_Order_Receipt_Item) ? $this->Purchase_Order_Receipt_Item : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Receipt_Item method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Receipt_Item method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Receipt_ItemForArrayConstraintsFromSetPurchase_Order_Receipt_Item(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPurchase_Order_Receipt_ItemPurchase_Order_Receipt_ItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfPurchase_Order_Receipt_ItemPurchase_Order_Receipt_ItemItem instanceof \Stellae\StructType\Purchase_Order_Receipt_Item) {
                $invalidValues[] = is_object($arrayOfPurchase_Order_Receipt_ItemPurchase_Order_Receipt_ItemItem) ? get_class($arrayOfPurchase_Order_Receipt_ItemPurchase_Order_Receipt_ItemItem) : sprintf('%s(%s)', gettype($arrayOfPurchase_Order_Receipt_ItemPurchase_Order_Receipt_ItemItem), var_export($arrayOfPurchase_Order_Receipt_ItemPurchase_Order_Receipt_ItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Receipt_Item property can only contain items of type \Stellae\StructType\Purchase_Order_Receipt_Item, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Receipt_Item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Stellae\StructType\Purchase_Order_Receipt_Item[] $purchase_Order_Receipt_Item
     * @return \Stellae\ArrayType\ArrayOfPurchase_Order_Receipt_Item
     */
    public function setPurchase_Order_Receipt_Item(array $purchase_Order_Receipt_Item = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Receipt_ItemArrayErrorMessage = self::validatePurchase_Order_Receipt_ItemForArrayConstraintsFromSetPurchase_Order_Receipt_Item($purchase_Order_Receipt_Item))) {
            throw new \InvalidArgumentException($purchase_Order_Receipt_ItemArrayErrorMessage, __LINE__);
        }
        if (is_null($purchase_Order_Receipt_Item) || (is_array($purchase_Order_Receipt_Item) && empty($purchase_Order_Receipt_Item))) {
            unset($this->Purchase_Order_Receipt_Item);
        } else {
            $this->Purchase_Order_Receipt_Item = $purchase_Order_Receipt_Item;
        }
        return $this;
    }
    /**
     * Add item to Purchase_Order_Receipt_Item value
     * @throws \InvalidArgumentException
     * @param \Stellae\StructType\Purchase_Order_Receipt_Item $item
     * @return \Stellae\ArrayType\ArrayOfPurchase_Order_Receipt_Item
     */
    public function addToPurchase_Order_Receipt_Item(\Stellae\StructType\Purchase_Order_Receipt_Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Stellae\StructType\Purchase_Order_Receipt_Item) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Receipt_Item property can only contain items of type \Stellae\StructType\Purchase_Order_Receipt_Item, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Receipt_Item[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stellae\StructType\Purchase_Order_Receipt_Item|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stellae\StructType\Purchase_Order_Receipt_Item|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stellae\StructType\Purchase_Order_Receipt_Item|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stellae\StructType\Purchase_Order_Receipt_Item|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stellae\StructType\Purchase_Order_Receipt_Item|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Purchase_Order_Receipt_Item
     */
    public function getAttributeName()
    {
        return 'Purchase_Order_Receipt_Item';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Stellae\ArrayType\ArrayOfPurchase_Order_Receipt_Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
