<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obj ServiceType
 * @subpackage Services
 */
class Obj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named objTest
     * Meta information extracted from the WSDL
     * - documentation: Test Vista Web Service Components
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObjTest $parameters
     * @return \StructType\ObjTestResponse|bool
     */
    public function objTest(\StructType\ObjTest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->objTest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named objExecute
     * Meta information extracted from the WSDL
     * - documentation: Executes the command and returns result
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObjExecute $parameters
     * @return \StructType\ObjExecuteResponse|bool
     */
    public function objExecute(\StructType\ObjExecute $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->objExecute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ObjExecuteResponse|\StructType\ObjTestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
