<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for weather_item_type StructType
 * @subpackage Structs
 */
class Weather_item_type extends AbstractStructBase
{
    /**
     * The weather_item_code
     * Meta information extracted from the WSDL
     * - documentation: Weather item type (Wind, Wave etc)
     * @var string
     */
    public $weather_item_code;
    /**
     * The value_min
     * Meta information extracted from the WSDL
     * - documentation: Actual or Minimum value
     * @var float
     */
    public $value_min;
    /**
     * The value_max
     * Meta information extracted from the WSDL
     * - documentation: Maximum value
     * - minOccurs: 0
     * @var float
     */
    public $value_max;
    /**
     * The value_gusts
     * Meta information extracted from the WSDL
     * - documentation: Gusts value (Wind)
     * - minOccurs: 0
     * @var float
     */
    public $value_gusts;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - documentation: Unit of the value
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * The weather_category_code
     * Meta information extracted from the WSDL
     * - documentation: Classification of wind report
     * - minOccurs: 0
     * @var string
     */
    public $weather_category_code;
    /**
     * The direction_code_min
     * Meta information extracted from the WSDL
     * - documentation: Direction of wind or wave
     * - minOccurs: 0
     * @var string
     */
    public $direction_code_min;
    /**
     * The direction_code_max
     * Meta information extracted from the WSDL
     * - documentation: Direction of wind or wave
     * - minOccurs: 0
     * @var string
     */
    public $direction_code_max;
    /**
     * Constructor method for weather_item_type
     * @uses Weather_item_type::setWeather_item_code()
     * @uses Weather_item_type::setValue_min()
     * @uses Weather_item_type::setValue_max()
     * @uses Weather_item_type::setValue_gusts()
     * @uses Weather_item_type::setUnit()
     * @uses Weather_item_type::setWeather_category_code()
     * @uses Weather_item_type::setDirection_code_min()
     * @uses Weather_item_type::setDirection_code_max()
     * @param string $weather_item_code
     * @param float $value_min
     * @param float $value_max
     * @param float $value_gusts
     * @param string $unit
     * @param string $weather_category_code
     * @param string $direction_code_min
     * @param string $direction_code_max
     */
    public function __construct($weather_item_code = null, $value_min = null, $value_max = null, $value_gusts = null, $unit = null, $weather_category_code = null, $direction_code_min = null, $direction_code_max = null)
    {
        $this
            ->setWeather_item_code($weather_item_code)
            ->setValue_min($value_min)
            ->setValue_max($value_max)
            ->setValue_gusts($value_gusts)
            ->setUnit($unit)
            ->setWeather_category_code($weather_category_code)
            ->setDirection_code_min($direction_code_min)
            ->setDirection_code_max($direction_code_max);
    }
    /**
     * Get weather_item_code value
     * @return string|null
     */
    public function getWeather_item_code()
    {
        return $this->weather_item_code;
    }
    /**
     * Set weather_item_code value
     * @uses \EnumType\Weather_item_code_enum::valueIsValid()
     * @uses \EnumType\Weather_item_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weather_item_code
     * @return \StructType\Weather_item_type
     */
    public function setWeather_item_code($weather_item_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Weather_item_code_enum::valueIsValid($weather_item_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Weather_item_code_enum', is_array($weather_item_code) ? implode(', ', $weather_item_code) : var_export($weather_item_code, true), implode(', ', \EnumType\Weather_item_code_enum::getValidValues())), __LINE__);
        }
        $this->weather_item_code = $weather_item_code;
        return $this;
    }
    /**
     * Get value_min value
     * @return float|null
     */
    public function getValue_min()
    {
        return $this->value_min;
    }
    /**
     * Set value_min value
     * @param float $value_min
     * @return \StructType\Weather_item_type
     */
    public function setValue_min($value_min = null)
    {
        // validation for constraint: float
        if (!is_null($value_min) && !(is_float($value_min) || is_numeric($value_min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value_min, true), gettype($value_min)), __LINE__);
        }
        $this->value_min = $value_min;
        return $this;
    }
    /**
     * Get value_max value
     * @return float|null
     */
    public function getValue_max()
    {
        return $this->value_max;
    }
    /**
     * Set value_max value
     * @param float $value_max
     * @return \StructType\Weather_item_type
     */
    public function setValue_max($value_max = null)
    {
        // validation for constraint: float
        if (!is_null($value_max) && !(is_float($value_max) || is_numeric($value_max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value_max, true), gettype($value_max)), __LINE__);
        }
        $this->value_max = $value_max;
        return $this;
    }
    /**
     * Get value_gusts value
     * @return float|null
     */
    public function getValue_gusts()
    {
        return $this->value_gusts;
    }
    /**
     * Set value_gusts value
     * @param float $value_gusts
     * @return \StructType\Weather_item_type
     */
    public function setValue_gusts($value_gusts = null)
    {
        // validation for constraint: float
        if (!is_null($value_gusts) && !(is_float($value_gusts) || is_numeric($value_gusts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value_gusts, true), gettype($value_gusts)), __LINE__);
        }
        $this->value_gusts = $value_gusts;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses \EnumType\Unit_enum::valueIsValid()
     * @uses \EnumType\Unit_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\Weather_item_type
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Unit_enum::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Unit_enum', is_array($unit) ? implode(', ', $unit) : var_export($unit, true), implode(', ', \EnumType\Unit_enum::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get weather_category_code value
     * @return string|null
     */
    public function getWeather_category_code()
    {
        return $this->weather_category_code;
    }
    /**
     * Set weather_category_code value
     * @uses \EnumType\Weather_category_code_enum::valueIsValid()
     * @uses \EnumType\Weather_category_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weather_category_code
     * @return \StructType\Weather_item_type
     */
    public function setWeather_category_code($weather_category_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Weather_category_code_enum::valueIsValid($weather_category_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Weather_category_code_enum', is_array($weather_category_code) ? implode(', ', $weather_category_code) : var_export($weather_category_code, true), implode(', ', \EnumType\Weather_category_code_enum::getValidValues())), __LINE__);
        }
        $this->weather_category_code = $weather_category_code;
        return $this;
    }
    /**
     * Get direction_code_min value
     * @return string|null
     */
    public function getDirection_code_min()
    {
        return $this->direction_code_min;
    }
    /**
     * Set direction_code_min value
     * @uses \EnumType\Weather_direction_code_enum::valueIsValid()
     * @uses \EnumType\Weather_direction_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction_code_min
     * @return \StructType\Weather_item_type
     */
    public function setDirection_code_min($direction_code_min = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Weather_direction_code_enum::valueIsValid($direction_code_min)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Weather_direction_code_enum', is_array($direction_code_min) ? implode(', ', $direction_code_min) : var_export($direction_code_min, true), implode(', ', \EnumType\Weather_direction_code_enum::getValidValues())), __LINE__);
        }
        $this->direction_code_min = $direction_code_min;
        return $this;
    }
    /**
     * Get direction_code_max value
     * @return string|null
     */
    public function getDirection_code_max()
    {
        return $this->direction_code_max;
    }
    /**
     * Set direction_code_max value
     * @uses \EnumType\Weather_direction_code_enum::valueIsValid()
     * @uses \EnumType\Weather_direction_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction_code_max
     * @return \StructType\Weather_item_type
     */
    public function setDirection_code_max($direction_code_max = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Weather_direction_code_enum::valueIsValid($direction_code_max)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Weather_direction_code_enum', is_array($direction_code_max) ? implode(', ', $direction_code_max) : var_export($direction_code_max, true), implode(', ', \EnumType\Weather_direction_code_enum::getValidValues())), __LINE__);
        }
        $this->direction_code_max = $direction_code_max;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Weather_item_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
