<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for identification_type StructType
 * @subpackage Structs
 */
class Identification_type extends AbstractStructBase
{
    /**
     * The internal_id
     * Meta information extracted from the WSDL
     * - documentation: Internal ID | Internal ID - best practice: global unique identifier
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $internal_id;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - documentation: Sender (System) of the message
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $from;
    /**
     * The originator
     * Meta information extracted from the WSDL
     * - documentation: Originator (initiator) of the information in this message
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $originator;
    /**
     * The country_code
     * Meta information extracted from the WSDL
     * - documentation: Country where message is valid
     * @var string
     */
    public $country_code;
    /**
     * The language_code
     * Meta information extracted from the WSDL
     * - documentation: Original language used in the textual info. (contents)
     * @var string
     */
    public $language_code;
    /**
     * The district
     * Meta information extracted from the WSDL
     * - documentation: District / Region within the specified country, where the message is applicable
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $district;
    /**
     * The date_issue
     * Meta information extracted from the WSDL
     * - documentation: Date and time of publication including time zone
     * @var string
     */
    public $date_issue;
    /**
     * Constructor method for identification_type
     * @uses Identification_type::setInternal_id()
     * @uses Identification_type::setFrom()
     * @uses Identification_type::setOriginator()
     * @uses Identification_type::setCountry_code()
     * @uses Identification_type::setLanguage_code()
     * @uses Identification_type::setDistrict()
     * @uses Identification_type::setDate_issue()
     * @param string $internal_id
     * @param string $from
     * @param string $originator
     * @param string $country_code
     * @param string $language_code
     * @param string $district
     * @param string $date_issue
     */
    public function __construct($internal_id = null, $from = null, $originator = null, $country_code = null, $language_code = null, $district = null, $date_issue = null)
    {
        $this
            ->setInternal_id($internal_id)
            ->setFrom($from)
            ->setOriginator($originator)
            ->setCountry_code($country_code)
            ->setLanguage_code($language_code)
            ->setDistrict($district)
            ->setDate_issue($date_issue);
    }
    /**
     * Get internal_id value
     * @return string|null
     */
    public function getInternal_id()
    {
        return $this->internal_id;
    }
    /**
     * Set internal_id value
     * @param string $internal_id
     * @return \StructType\Identification_type
     */
    public function setInternal_id($internal_id = null)
    {
        // validation for constraint: string
        if (!is_null($internal_id) && !is_string($internal_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_id, true), gettype($internal_id)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($internal_id) && mb_strlen($internal_id) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($internal_id)), __LINE__);
        }
        $this->internal_id = $internal_id;
        return $this;
    }
    /**
     * Get from value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\Identification_type
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($from) && mb_strlen($from) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get originator value
     * @return string|null
     */
    public function getOriginator()
    {
        return $this->originator;
    }
    /**
     * Set originator value
     * @param string $originator
     * @return \StructType\Identification_type
     */
    public function setOriginator($originator = null)
    {
        // validation for constraint: string
        if (!is_null($originator) && !is_string($originator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originator, true), gettype($originator)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($originator) && mb_strlen($originator) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($originator)), __LINE__);
        }
        $this->originator = $originator;
        return $this;
    }
    /**
     * Get country_code value
     * @return string|null
     */
    public function getCountry_code()
    {
        return $this->country_code;
    }
    /**
     * Set country_code value
     * @uses \EnumType\Country_code_enum::valueIsValid()
     * @uses \EnumType\Country_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country_code
     * @return \StructType\Identification_type
     */
    public function setCountry_code($country_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country_code_enum::valueIsValid($country_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country_code_enum', is_array($country_code) ? implode(', ', $country_code) : var_export($country_code, true), implode(', ', \EnumType\Country_code_enum::getValidValues())), __LINE__);
        }
        $this->country_code = $country_code;
        return $this;
    }
    /**
     * Get language_code value
     * @return string|null
     */
    public function getLanguage_code()
    {
        return $this->language_code;
    }
    /**
     * Set language_code value
     * @uses \EnumType\Language_code_enum::valueIsValid()
     * @uses \EnumType\Language_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language_code
     * @return \StructType\Identification_type
     */
    public function setLanguage_code($language_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language_code_enum::valueIsValid($language_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language_code_enum', is_array($language_code) ? implode(', ', $language_code) : var_export($language_code, true), implode(', ', \EnumType\Language_code_enum::getValidValues())), __LINE__);
        }
        $this->language_code = $language_code;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \StructType\Identification_type
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($district) && mb_strlen($district) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get date_issue value
     * @return string|null
     */
    public function getDate_issue()
    {
        return $this->date_issue;
    }
    /**
     * Set date_issue value
     * @param string $date_issue
     * @return \StructType\Identification_type
     */
    public function setDate_issue($date_issue = null)
    {
        // validation for constraint: string
        if (!is_null($date_issue) && !is_string($date_issue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_issue, true), gettype($date_issue)), __LINE__);
        }
        $this->date_issue = $date_issue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Identification_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
