<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fairway_section_type StructType
 * @subpackage Structs
 */
class Fairway_section_type extends AbstractStructBase
{
    /**
     * The geo_object
     * Meta information extracted from the WSDL
     * - documentation: Geo information of fairway
     * @var \StructType\Geo_object_type
     */
    public $geo_object;
    /**
     * The limitation
     * Meta information extracted from the WSDL
     * - documentation: Fairway section limitations
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Limitation_type[]
     */
    public $limitation;
    /**
     * Constructor method for fairway_section_type
     * @uses Fairway_section_type::setGeo_object()
     * @uses Fairway_section_type::setLimitation()
     * @param \StructType\Geo_object_type $geo_object
     * @param \StructType\Limitation_type[] $limitation
     */
    public function __construct(\StructType\Geo_object_type $geo_object = null, array $limitation = array())
    {
        $this
            ->setGeo_object($geo_object)
            ->setLimitation($limitation);
    }
    /**
     * Get geo_object value
     * @return \StructType\Geo_object_type|null
     */
    public function getGeo_object()
    {
        return $this->geo_object;
    }
    /**
     * Set geo_object value
     * @param \StructType\Geo_object_type $geo_object
     * @return \StructType\Fairway_section_type
     */
    public function setGeo_object(\StructType\Geo_object_type $geo_object = null)
    {
        $this->geo_object = $geo_object;
        return $this;
    }
    /**
     * Get limitation value
     * @return \StructType\Limitation_type[]|null
     */
    public function getLimitation()
    {
        return $this->limitation;
    }
    /**
     * This method is responsible for validating the values passed to the setLimitation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLimitation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLimitationForArrayConstraintsFromSetLimitation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fairway_section_typeLimitationItem) {
            // validation for constraint: itemType
            if (!$fairway_section_typeLimitationItem instanceof \StructType\Limitation_type) {
                $invalidValues[] = is_object($fairway_section_typeLimitationItem) ? get_class($fairway_section_typeLimitationItem) : sprintf('%s(%s)', gettype($fairway_section_typeLimitationItem), var_export($fairway_section_typeLimitationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The limitation property can only contain items of type \StructType\Limitation_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set limitation value
     * @throws \InvalidArgumentException
     * @param \StructType\Limitation_type[] $limitation
     * @return \StructType\Fairway_section_type
     */
    public function setLimitation(array $limitation = array())
    {
        // validation for constraint: array
        if ('' !== ($limitationArrayErrorMessage = self::validateLimitationForArrayConstraintsFromSetLimitation($limitation))) {
            throw new \InvalidArgumentException($limitationArrayErrorMessage, __LINE__);
        }
        $this->limitation = $limitation;
        return $this;
    }
    /**
     * Add item to limitation value
     * @throws \InvalidArgumentException
     * @param \StructType\Limitation_type $item
     * @return \StructType\Fairway_section_type
     */
    public function addToLimitation(\StructType\Limitation_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Limitation_type) {
            throw new \InvalidArgumentException(sprintf('The limitation property can only contain items of type \StructType\Limitation_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->limitation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fairway_section_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
