<?php

namespace EnumType;

/**
 * This class stands for target_group_code_enum EnumType
 * @subpackage Enumerations
 */
class Target_group_code_enum
{
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'CDG'
     * @return string 'CDG'
     */
    const VALUE_CDG = 'CDG';
    /**
     * Constant for value 'COM'
     * @return string 'COM'
     */
    const VALUE_COM = 'COM';
    /**
     * Constant for value 'PAX'
     * @return string 'PAX'
     */
    const VALUE_PAX = 'PAX';
    /**
     * Constant for value 'PLE'
     * @return string 'PLE'
     */
    const VALUE_PLE = 'PLE';
    /**
     * Constant for value 'CNV'
     * @return string 'CNV'
     */
    const VALUE_CNV = 'CNV';
    /**
     * Constant for value 'PUS'
     * @return string 'PUS'
     */
    const VALUE_PUS = 'PUS';
    /**
     * Constant for value 'NNU'
     * @return string 'NNU'
     */
    const VALUE_NNU = 'NNU';
    /**
     * Constant for value 'LOA'
     * @return string 'LOA'
     */
    const VALUE_LOA = 'LOA';
    /**
     * Constant for value 'SMA'
     * @return string 'SMA'
     */
    const VALUE_SMA = 'SMA';
    /**
     * Constant for value 'CND'
     * @return string 'CND'
     */
    const VALUE_CND = 'CND';
    /**
     * Constant for value 'WOC'
     * @return string 'WOC'
     */
    const VALUE_WOC = 'WOC';
    /**
     * Constant for value 'MOV'
     * @return string 'MOV'
     */
    const VALUE_MOV = 'MOV';
    /**
     * Constant for value 'NMV'
     * @return string 'NMV'
     */
    const VALUE_NMV = 'NMV';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_CDG
     * @uses self::VALUE_COM
     * @uses self::VALUE_PAX
     * @uses self::VALUE_PLE
     * @uses self::VALUE_CNV
     * @uses self::VALUE_PUS
     * @uses self::VALUE_NNU
     * @uses self::VALUE_LOA
     * @uses self::VALUE_SMA
     * @uses self::VALUE_CND
     * @uses self::VALUE_WOC
     * @uses self::VALUE_MOV
     * @uses self::VALUE_NMV
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_CDG,
            self::VALUE_COM,
            self::VALUE_PAX,
            self::VALUE_PLE,
            self::VALUE_CNV,
            self::VALUE_PUS,
            self::VALUE_NNU,
            self::VALUE_LOA,
            self::VALUE_SMA,
            self::VALUE_CND,
            self::VALUE_WOC,
            self::VALUE_MOV,
            self::VALUE_NMV,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
