<?php

namespace EnumType;

/**
 * This class stands for reporting_code_enum EnumType
 * @subpackage Enumerations
 */
class Reporting_code_enum
{
    /**
     * Constant for value 'INF'
     * @return string 'INF'
     */
    const VALUE_INF = 'INF';
    /**
     * Constant for value 'ADD'
     * @return string 'ADD'
     */
    const VALUE_ADD = 'ADD';
    /**
     * Constant for value 'REG'
     * @return string 'REG'
     */
    const VALUE_REG = 'REG';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INF
     * @uses self::VALUE_ADD
     * @uses self::VALUE_REG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INF,
            self::VALUE_ADD,
            self::VALUE_REG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
