<?php

namespace EnumType;

/**
 * This class stands for regime_code_enum EnumType
 * @subpackage Enumerations
 */
class Regime_code_enum
{
    /**
     * Constant for value 'NO'
     * @return string 'NO'
     */
    const VALUE_NO = 'NO';
    /**
     * Constant for value 'HI'
     * @return string 'HI'
     */
    const VALUE_HI = 'HI';
    /**
     * Constant for value 'II'
     * @return string 'II'
     */
    const VALUE_II = 'II';
    /**
     * Constant for value 'I'
     * @return string 'I'
     */
    const VALUE_I = 'I';
    /**
     * Constant for value 'NN'
     * @return string 'NN'
     */
    const VALUE_NN = 'NN';
    /**
     * Constant for value 'LO'
     * @return string 'LO'
     */
    const VALUE_LO = 'LO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO
     * @uses self::VALUE_HI
     * @uses self::VALUE_II
     * @uses self::VALUE_I
     * @uses self::VALUE_NN
     * @uses self::VALUE_LO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO,
            self::VALUE_HI,
            self::VALUE_II,
            self::VALUE_I,
            self::VALUE_NN,
            self::VALUE_LO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
