<?php

namespace EnumType;

/**
 * This class stands for measure_code_enum EnumType
 * @subpackage Enumerations
 */
class Measure_code_enum
{
    /**
     * Constant for value 'DIS'
     * @return string 'DIS'
     */
    const VALUE_DIS = 'DIS';
    /**
     * Constant for value 'REG'
     * @return string 'REG'
     */
    const VALUE_REG = 'REG';
    /**
     * Constant for value 'BAR'
     * @return string 'BAR'
     */
    const VALUE_BAR = 'BAR';
    /**
     * Constant for value 'VER'
     * @return string 'VER'
     */
    const VALUE_VER = 'VER';
    /**
     * Constant for value 'LSD'
     * @return string 'LSD'
     */
    const VALUE_LSD = 'LSD';
    /**
     * Constant for value 'WAL'
     * @return string 'WAL'
     */
    const VALUE_WAL = 'WAL';
    /**
     * Constant for value 'NOM'
     * @return string 'NOM'
     */
    const VALUE_NOM = 'NOM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIS
     * @uses self::VALUE_REG
     * @uses self::VALUE_BAR
     * @uses self::VALUE_VER
     * @uses self::VALUE_LSD
     * @uses self::VALUE_WAL
     * @uses self::VALUE_NOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIS,
            self::VALUE_REG,
            self::VALUE_BAR,
            self::VALUE_VER,
            self::VALUE_LSD,
            self::VALUE_WAL,
            self::VALUE_NOM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
