<?php

namespace EnumType;

/**
 * This class stands for interval_code_enum EnumType
 * @subpackage Enumerations
 */
class Interval_code_enum
{
    /**
     * Constant for value 'CON'
     * @return string 'CON'
     */
    const VALUE_CON = 'CON';
    /**
     * Constant for value 'DAY'
     * @return string 'DAY'
     */
    const VALUE_DAY = 'DAY';
    /**
     * Constant for value 'WRK'
     * @return string 'WRK'
     */
    const VALUE_WRK = 'WRK';
    /**
     * Constant for value 'WKN'
     * @return string 'WKN'
     */
    const VALUE_WKN = 'WKN';
    /**
     * Constant for value 'SUN'
     * @return string 'SUN'
     */
    const VALUE_SUN = 'SUN';
    /**
     * Constant for value 'MON'
     * @return string 'MON'
     */
    const VALUE_MON = 'MON';
    /**
     * Constant for value 'TUE'
     * @return string 'TUE'
     */
    const VALUE_TUE = 'TUE';
    /**
     * Constant for value 'WED'
     * @return string 'WED'
     */
    const VALUE_WED = 'WED';
    /**
     * Constant for value 'THU'
     * @return string 'THU'
     */
    const VALUE_THU = 'THU';
    /**
     * Constant for value 'FRI'
     * @return string 'FRI'
     */
    const VALUE_FRI = 'FRI';
    /**
     * Constant for value 'SAT'
     * @return string 'SAT'
     */
    const VALUE_SAT = 'SAT';
    /**
     * Constant for value 'DTI'
     * @return string 'DTI'
     */
    const VALUE_DTI = 'DTI';
    /**
     * Constant for value 'NTI'
     * @return string 'NTI'
     */
    const VALUE_NTI = 'NTI';
    /**
     * Constant for value 'RVI'
     * @return string 'RVI'
     */
    const VALUE_RVI = 'RVI';
    /**
     * Constant for value 'EXC'
     * @return string 'EXC'
     */
    const VALUE_EXC = 'EXC';
    /**
     * Constant for value 'WRD'
     * @return string 'WRD'
     */
    const VALUE_WRD = 'WRD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CON
     * @uses self::VALUE_DAY
     * @uses self::VALUE_WRK
     * @uses self::VALUE_WKN
     * @uses self::VALUE_SUN
     * @uses self::VALUE_MON
     * @uses self::VALUE_TUE
     * @uses self::VALUE_WED
     * @uses self::VALUE_THU
     * @uses self::VALUE_FRI
     * @uses self::VALUE_SAT
     * @uses self::VALUE_DTI
     * @uses self::VALUE_NTI
     * @uses self::VALUE_RVI
     * @uses self::VALUE_EXC
     * @uses self::VALUE_WRD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CON,
            self::VALUE_DAY,
            self::VALUE_WRK,
            self::VALUE_WKN,
            self::VALUE_SUN,
            self::VALUE_MON,
            self::VALUE_TUE,
            self::VALUE_WED,
            self::VALUE_THU,
            self::VALUE_FRI,
            self::VALUE_SAT,
            self::VALUE_DTI,
            self::VALUE_NTI,
            self::VALUE_RVI,
            self::VALUE_EXC,
            self::VALUE_WRD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
