<?php

namespace EnumType;

/**
 * This class stands for communication_code_enum EnumType
 * @subpackage Enumerations
 */
class Communication_code_enum
{
    /**
     * Constant for value 'TE'
     * @return string 'TE'
     */
    const VALUE_TE = 'TE';
    /**
     * Constant for value 'AP'
     * @return string 'AP'
     */
    const VALUE_AP = 'AP';
    /**
     * Constant for value 'EM'
     * @return string 'EM'
     */
    const VALUE_EM = 'EM';
    /**
     * Constant for value 'AH'
     * @return string 'AH'
     */
    const VALUE_AH = 'AH';
    /**
     * Constant for value 'TT'
     * @return string 'TT'
     */
    const VALUE_TT = 'TT';
    /**
     * Constant for value 'FX'
     * @return string 'FX'
     */
    const VALUE_FX = 'FX';
    /**
     * Constant for value 'LS'
     * @return string 'LS'
     */
    const VALUE_LS = 'LS';
    /**
     * Constant for value 'FS'
     * @return string 'FS'
     */
    const VALUE_FS = 'FS';
    /**
     * Constant for value 'SO'
     * @return string 'SO'
     */
    const VALUE_SO = 'SO';
    /**
     * Constant for value 'EI'
     * @return string 'EI'
     */
    const VALUE_EI = 'EI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TE
     * @uses self::VALUE_AP
     * @uses self::VALUE_EM
     * @uses self::VALUE_AH
     * @uses self::VALUE_TT
     * @uses self::VALUE_FX
     * @uses self::VALUE_LS
     * @uses self::VALUE_FS
     * @uses self::VALUE_SO
     * @uses self::VALUE_EI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TE,
            self::VALUE_AP,
            self::VALUE_EM,
            self::VALUE_AH,
            self::VALUE_TT,
            self::VALUE_FX,
            self::VALUE_LS,
            self::VALUE_FS,
            self::VALUE_SO,
            self::VALUE_EI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
