<?php

namespace EnumType;

/**
 * This class stands for barrage_code_enum EnumType
 * @subpackage Enumerations
 */
class Barrage_code_enum
{
    /**
     * Constant for value 'CLD'
     * @return string 'CLD'
     */
    const VALUE_CLD = 'CLD';
    /**
     * Constant for value 'OPG'
     * @return string 'OPG'
     */
    const VALUE_OPG = 'OPG';
    /**
     * Constant for value 'CLG'
     * @return string 'CLG'
     */
    const VALUE_CLG = 'CLG';
    /**
     * Constant for value 'OPD'
     * @return string 'OPD'
     */
    const VALUE_OPD = 'OPD';
    /**
     * Constant for value 'OPN'
     * @return string 'OPN'
     */
    const VALUE_OPN = 'OPN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLD
     * @uses self::VALUE_OPG
     * @uses self::VALUE_CLG
     * @uses self::VALUE_OPD
     * @uses self::VALUE_OPN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLD,
            self::VALUE_OPG,
            self::VALUE_CLG,
            self::VALUE_OPD,
            self::VALUE_OPN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
