<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for wrm_type StructType
 * @subpackage Structs
 */
class Wrm_type extends AbstractStructBase
{
    /**
     * The internal_id
     * Meta information extracted from the WSDL
     * - documentation: Internal ID | Internal ID - best practice: global unique identifier
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $internal_id;
    /**
     * The nts_number
     * Meta information extracted from the WSDL
     * - documentation: NtS Number
     * - minOccurs: 0
     * @var \StructType\Nts_number_type
     */
    public $nts_number;
    /**
     * The validity_period
     * Meta information extracted from the WSDL
     * - documentation: Overall period of validity
     * @var \StructType\Validity_period_type
     */
    public $validity_period;
    /**
     * The geo_object
     * Meta information extracted from the WSDL
     * - documentation: Object section
     * @var \StructType\Geo_object_type
     */
    public $geo_object;
    /**
     * The reference_code
     * Meta information extracted from the WSDL
     * - documentation: Value reference (measurement reference)
     * - minOccurs: 0
     * @var string
     */
    public $reference_code;
    /**
     * The measure
     * Meta information extracted from the WSDL
     * - documentation: Measurements (normal or predicted values)
     * - maxOccurs: unbounded
     * @var \StructType\Measure_type[]
     */
    public $measure;
    /**
     * Constructor method for wrm_type
     * @uses Wrm_type::setInternal_id()
     * @uses Wrm_type::setNts_number()
     * @uses Wrm_type::setValidity_period()
     * @uses Wrm_type::setGeo_object()
     * @uses Wrm_type::setReference_code()
     * @uses Wrm_type::setMeasure()
     * @param string $internal_id
     * @param \StructType\Nts_number_type $nts_number
     * @param \StructType\Validity_period_type $validity_period
     * @param \StructType\Geo_object_type $geo_object
     * @param string $reference_code
     * @param \StructType\Measure_type[] $measure
     */
    public function __construct($internal_id = null, \StructType\Nts_number_type $nts_number = null, \StructType\Validity_period_type $validity_period = null, \StructType\Geo_object_type $geo_object = null, $reference_code = null, array $measure = array())
    {
        $this
            ->setInternal_id($internal_id)
            ->setNts_number($nts_number)
            ->setValidity_period($validity_period)
            ->setGeo_object($geo_object)
            ->setReference_code($reference_code)
            ->setMeasure($measure);
    }
    /**
     * Get internal_id value
     * @return string|null
     */
    public function getInternal_id()
    {
        return $this->internal_id;
    }
    /**
     * Set internal_id value
     * @param string $internal_id
     * @return \StructType\Wrm_type
     */
    public function setInternal_id($internal_id = null)
    {
        // validation for constraint: string
        if (!is_null($internal_id) && !is_string($internal_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_id, true), gettype($internal_id)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($internal_id) && mb_strlen($internal_id) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($internal_id)), __LINE__);
        }
        $this->internal_id = $internal_id;
        return $this;
    }
    /**
     * Get nts_number value
     * @return \StructType\Nts_number_type|null
     */
    public function getNts_number()
    {
        return $this->nts_number;
    }
    /**
     * Set nts_number value
     * @param \StructType\Nts_number_type $nts_number
     * @return \StructType\Wrm_type
     */
    public function setNts_number(\StructType\Nts_number_type $nts_number = null)
    {
        $this->nts_number = $nts_number;
        return $this;
    }
    /**
     * Get validity_period value
     * @return \StructType\Validity_period_type|null
     */
    public function getValidity_period()
    {
        return $this->validity_period;
    }
    /**
     * Set validity_period value
     * @param \StructType\Validity_period_type $validity_period
     * @return \StructType\Wrm_type
     */
    public function setValidity_period(\StructType\Validity_period_type $validity_period = null)
    {
        $this->validity_period = $validity_period;
        return $this;
    }
    /**
     * Get geo_object value
     * @return \StructType\Geo_object_type|null
     */
    public function getGeo_object()
    {
        return $this->geo_object;
    }
    /**
     * Set geo_object value
     * @param \StructType\Geo_object_type $geo_object
     * @return \StructType\Wrm_type
     */
    public function setGeo_object(\StructType\Geo_object_type $geo_object = null)
    {
        $this->geo_object = $geo_object;
        return $this;
    }
    /**
     * Get reference_code value
     * @return string|null
     */
    public function getReference_code()
    {
        return $this->reference_code;
    }
    /**
     * Set reference_code value
     * @uses \EnumType\Reference_code_enum::valueIsValid()
     * @uses \EnumType\Reference_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reference_code
     * @return \StructType\Wrm_type
     */
    public function setReference_code($reference_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Reference_code_enum::valueIsValid($reference_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Reference_code_enum', is_array($reference_code) ? implode(', ', $reference_code) : var_export($reference_code, true), implode(', ', \EnumType\Reference_code_enum::getValidValues())), __LINE__);
        }
        $this->reference_code = $reference_code;
        return $this;
    }
    /**
     * Get measure value
     * @return \StructType\Measure_type[]|null
     */
    public function getMeasure()
    {
        return $this->measure;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasure method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasure method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasureForArrayConstraintsFromSetMeasure(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $wrm_typeMeasureItem) {
            // validation for constraint: itemType
            if (!$wrm_typeMeasureItem instanceof \StructType\Measure_type) {
                $invalidValues[] = is_object($wrm_typeMeasureItem) ? get_class($wrm_typeMeasureItem) : sprintf('%s(%s)', gettype($wrm_typeMeasureItem), var_export($wrm_typeMeasureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The measure property can only contain items of type \StructType\Measure_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set measure value
     * @throws \InvalidArgumentException
     * @param \StructType\Measure_type[] $measure
     * @return \StructType\Wrm_type
     */
    public function setMeasure(array $measure = array())
    {
        // validation for constraint: array
        if ('' !== ($measureArrayErrorMessage = self::validateMeasureForArrayConstraintsFromSetMeasure($measure))) {
            throw new \InvalidArgumentException($measureArrayErrorMessage, __LINE__);
        }
        $this->measure = $measure;
        return $this;
    }
    /**
     * Add item to measure value
     * @throws \InvalidArgumentException
     * @param \StructType\Measure_type $item
     * @return \StructType\Wrm_type
     */
    public function addToMeasure(\StructType\Measure_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Measure_type) {
            throw new \InvalidArgumentException(sprintf('The measure property can only contain items of type \StructType\Measure_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->measure[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Wrm_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
