<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for target_group_type StructType
 * @subpackage Structs
 */
class Target_group_type extends AbstractStructBase
{
    /**
     * The target_group_code
     * Meta information extracted from the WSDL
     * - documentation: Target group (vessel type)
     * - default: ALL
     * @var string
     */
    public $target_group_code;
    /**
     * The direction_code
     * Meta information extracted from the WSDL
     * - documentation: Upstream or downstream traffic, or both
     * - default: ALL
     * @var string
     */
    public $direction_code;
    /**
     * Constructor method for target_group_type
     * @uses Target_group_type::setTarget_group_code()
     * @uses Target_group_type::setDirection_code()
     * @param string $target_group_code
     * @param string $direction_code
     */
    public function __construct($target_group_code = 'ALL', $direction_code = 'ALL')
    {
        $this
            ->setTarget_group_code($target_group_code)
            ->setDirection_code($direction_code);
    }
    /**
     * Get target_group_code value
     * @return string|null
     */
    public function getTarget_group_code()
    {
        return $this->target_group_code;
    }
    /**
     * Set target_group_code value
     * @uses \EnumType\Target_group_code_enum::valueIsValid()
     * @uses \EnumType\Target_group_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target_group_code
     * @return \StructType\Target_group_type
     */
    public function setTarget_group_code($target_group_code = 'ALL')
    {
        // validation for constraint: enumeration
        if (!\EnumType\Target_group_code_enum::valueIsValid($target_group_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Target_group_code_enum', is_array($target_group_code) ? implode(', ', $target_group_code) : var_export($target_group_code, true), implode(', ', \EnumType\Target_group_code_enum::getValidValues())), __LINE__);
        }
        $this->target_group_code = $target_group_code;
        return $this;
    }
    /**
     * Get direction_code value
     * @return string|null
     */
    public function getDirection_code()
    {
        return $this->direction_code;
    }
    /**
     * Set direction_code value
     * @uses \EnumType\Direction_code_enum::valueIsValid()
     * @uses \EnumType\Direction_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction_code
     * @return \StructType\Target_group_type
     */
    public function setDirection_code($direction_code = 'ALL')
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction_code_enum::valueIsValid($direction_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction_code_enum', is_array($direction_code) ? implode(', ', $direction_code) : var_export($direction_code, true), implode(', ', \EnumType\Direction_code_enum::getValidValues())), __LINE__);
        }
        $this->direction_code = $direction_code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Target_group_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
