<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for measure_type StructType
 * @subpackage Structs
 */
class Measure_type extends AbstractStructBase
{
    /**
     * The predicted
     * Meta information extracted from the WSDL
     * - documentation: Predicted measurement (1 or true) or real measurement (0 or false)
     * @var bool
     */
    public $predicted;
    /**
     * The measure_code
     * Meta information extracted from the WSDL
     * - documentation: Kind of water related information
     * @var string
     */
    public $measure_code;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: Measured or predicted value
     * - minOccurs: 0
     * @var float
     */
    public $value;
    /**
     * The value_min
     * Meta information extracted from the WSDL
     * - documentation: Lowest value of confidence interval
     * - minOccurs: 0
     * @var float
     */
    public $value_min;
    /**
     * The value_max
     * Meta information extracted from the WSDL
     * - documentation: Highest value of confidence interval
     * - minOccurs: 0
     * @var float
     */
    public $value_max;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - documentation: Unit of the water related value
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * The barrage_code
     * Meta information extracted from the WSDL
     * - documentation: Barrage status
     * - minOccurs: 0
     * @var string
     */
    public $barrage_code;
    /**
     * The regime_code
     * Meta information extracted from the WSDL
     * - documentation: Regime applicable
     * - minOccurs: 0
     * @var string
     */
    public $regime_code;
    /**
     * The measuredate
     * Meta information extracted from the WSDL
     * - documentation: Date and Time of measurement or predicted value including time zone
     * @var string
     */
    public $measuredate;
    /**
     * The difference
     * Meta information extracted from the WSDL
     * - documentation: Difference with comparative value
     * - minOccurs: 0
     * @var \StructType\Difference_type
     */
    public $difference;
    /**
     * Constructor method for measure_type
     * @uses Measure_type::setPredicted()
     * @uses Measure_type::setMeasure_code()
     * @uses Measure_type::setValue()
     * @uses Measure_type::setValue_min()
     * @uses Measure_type::setValue_max()
     * @uses Measure_type::setUnit()
     * @uses Measure_type::setBarrage_code()
     * @uses Measure_type::setRegime_code()
     * @uses Measure_type::setMeasuredate()
     * @uses Measure_type::setDifference()
     * @param bool $predicted
     * @param string $measure_code
     * @param float $value
     * @param float $value_min
     * @param float $value_max
     * @param string $unit
     * @param string $barrage_code
     * @param string $regime_code
     * @param string $measuredate
     * @param \StructType\Difference_type $difference
     */
    public function __construct($predicted = null, $measure_code = null, $value = null, $value_min = null, $value_max = null, $unit = null, $barrage_code = null, $regime_code = null, $measuredate = null, \StructType\Difference_type $difference = null)
    {
        $this
            ->setPredicted($predicted)
            ->setMeasure_code($measure_code)
            ->setValue($value)
            ->setValue_min($value_min)
            ->setValue_max($value_max)
            ->setUnit($unit)
            ->setBarrage_code($barrage_code)
            ->setRegime_code($regime_code)
            ->setMeasuredate($measuredate)
            ->setDifference($difference);
    }
    /**
     * Get predicted value
     * @return bool|null
     */
    public function getPredicted()
    {
        return $this->predicted;
    }
    /**
     * Set predicted value
     * @param bool $predicted
     * @return \StructType\Measure_type
     */
    public function setPredicted($predicted = null)
    {
        // validation for constraint: boolean
        if (!is_null($predicted) && !is_bool($predicted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($predicted, true), gettype($predicted)), __LINE__);
        }
        $this->predicted = $predicted;
        return $this;
    }
    /**
     * Get measure_code value
     * @return string|null
     */
    public function getMeasure_code()
    {
        return $this->measure_code;
    }
    /**
     * Set measure_code value
     * @uses \EnumType\Measure_code_enum::valueIsValid()
     * @uses \EnumType\Measure_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $measure_code
     * @return \StructType\Measure_type
     */
    public function setMeasure_code($measure_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Measure_code_enum::valueIsValid($measure_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Measure_code_enum', is_array($measure_code) ? implode(', ', $measure_code) : var_export($measure_code, true), implode(', ', \EnumType\Measure_code_enum::getValidValues())), __LINE__);
        }
        $this->measure_code = $measure_code;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\Measure_type
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get value_min value
     * @return float|null
     */
    public function getValue_min()
    {
        return $this->value_min;
    }
    /**
     * Set value_min value
     * @param float $value_min
     * @return \StructType\Measure_type
     */
    public function setValue_min($value_min = null)
    {
        // validation for constraint: float
        if (!is_null($value_min) && !(is_float($value_min) || is_numeric($value_min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value_min, true), gettype($value_min)), __LINE__);
        }
        $this->value_min = $value_min;
        return $this;
    }
    /**
     * Get value_max value
     * @return float|null
     */
    public function getValue_max()
    {
        return $this->value_max;
    }
    /**
     * Set value_max value
     * @param float $value_max
     * @return \StructType\Measure_type
     */
    public function setValue_max($value_max = null)
    {
        // validation for constraint: float
        if (!is_null($value_max) && !(is_float($value_max) || is_numeric($value_max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value_max, true), gettype($value_max)), __LINE__);
        }
        $this->value_max = $value_max;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses \EnumType\Unit_enum::valueIsValid()
     * @uses \EnumType\Unit_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\Measure_type
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Unit_enum::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Unit_enum', is_array($unit) ? implode(', ', $unit) : var_export($unit, true), implode(', ', \EnumType\Unit_enum::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get barrage_code value
     * @return string|null
     */
    public function getBarrage_code()
    {
        return $this->barrage_code;
    }
    /**
     * Set barrage_code value
     * @uses \EnumType\Barrage_code_enum::valueIsValid()
     * @uses \EnumType\Barrage_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $barrage_code
     * @return \StructType\Measure_type
     */
    public function setBarrage_code($barrage_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Barrage_code_enum::valueIsValid($barrage_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Barrage_code_enum', is_array($barrage_code) ? implode(', ', $barrage_code) : var_export($barrage_code, true), implode(', ', \EnumType\Barrage_code_enum::getValidValues())), __LINE__);
        }
        $this->barrage_code = $barrage_code;
        return $this;
    }
    /**
     * Get regime_code value
     * @return string|null
     */
    public function getRegime_code()
    {
        return $this->regime_code;
    }
    /**
     * Set regime_code value
     * @uses \EnumType\Regime_code_enum::valueIsValid()
     * @uses \EnumType\Regime_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regime_code
     * @return \StructType\Measure_type
     */
    public function setRegime_code($regime_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Regime_code_enum::valueIsValid($regime_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Regime_code_enum', is_array($regime_code) ? implode(', ', $regime_code) : var_export($regime_code, true), implode(', ', \EnumType\Regime_code_enum::getValidValues())), __LINE__);
        }
        $this->regime_code = $regime_code;
        return $this;
    }
    /**
     * Get measuredate value
     * @return string|null
     */
    public function getMeasuredate()
    {
        return $this->measuredate;
    }
    /**
     * Set measuredate value
     * @param string $measuredate
     * @return \StructType\Measure_type
     */
    public function setMeasuredate($measuredate = null)
    {
        // validation for constraint: string
        if (!is_null($measuredate) && !is_string($measuredate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measuredate, true), gettype($measuredate)), __LINE__);
        }
        $this->measuredate = $measuredate;
        return $this;
    }
    /**
     * Get difference value
     * @return \StructType\Difference_type|null
     */
    public function getDifference()
    {
        return $this->difference;
    }
    /**
     * Set difference value
     * @param \StructType\Difference_type $difference
     * @return \StructType\Measure_type
     */
    public function setDifference(\StructType\Difference_type $difference = null)
    {
        $this->difference = $difference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Measure_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
