<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for limitation_period_type StructType
 * @subpackage Structs
 */
class Limitation_period_type extends AbstractStructBase
{
    /**
     * The date_start
     * Meta information extracted from the WSDL
     * - documentation: Start date of limitation period including time zone
     * @var string
     */
    public $date_start;
    /**
     * The date_end
     * Meta information extracted from the WSDL
     * - documentation: End date of limitation period including time zone
     * - minOccurs: 0
     * @var string
     */
    public $date_end;
    /**
     * The time_start
     * Meta information extracted from the WSDL
     * - documentation: Start time of limitation period without time zone
     * - minOccurs: 0
     * @var string
     */
    public $time_start;
    /**
     * The time_end
     * Meta information extracted from the WSDL
     * - documentation: End time of limitation period without time zone
     * - minOccurs: 0
     * @var string
     */
    public $time_end;
    /**
     * The interval_code
     * Meta information extracted from the WSDL
     * - documentation: Interval for limitation if applicable
     * - minOccurs: 0
     * @var string
     */
    public $interval_code;
    /**
     * Constructor method for limitation_period_type
     * @uses Limitation_period_type::setDate_start()
     * @uses Limitation_period_type::setDate_end()
     * @uses Limitation_period_type::setTime_start()
     * @uses Limitation_period_type::setTime_end()
     * @uses Limitation_period_type::setInterval_code()
     * @param string $date_start
     * @param string $date_end
     * @param string $time_start
     * @param string $time_end
     * @param string $interval_code
     */
    public function __construct($date_start = null, $date_end = null, $time_start = null, $time_end = null, $interval_code = null)
    {
        $this
            ->setDate_start($date_start)
            ->setDate_end($date_end)
            ->setTime_start($time_start)
            ->setTime_end($time_end)
            ->setInterval_code($interval_code);
    }
    /**
     * Get date_start value
     * @return string|null
     */
    public function getDate_start()
    {
        return $this->date_start;
    }
    /**
     * Set date_start value
     * @param string $date_start
     * @return \StructType\Limitation_period_type
     */
    public function setDate_start($date_start = null)
    {
        // validation for constraint: string
        if (!is_null($date_start) && !is_string($date_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_start, true), gettype($date_start)), __LINE__);
        }
        $this->date_start = $date_start;
        return $this;
    }
    /**
     * Get date_end value
     * @return string|null
     */
    public function getDate_end()
    {
        return $this->date_end;
    }
    /**
     * Set date_end value
     * @param string $date_end
     * @return \StructType\Limitation_period_type
     */
    public function setDate_end($date_end = null)
    {
        // validation for constraint: string
        if (!is_null($date_end) && !is_string($date_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_end, true), gettype($date_end)), __LINE__);
        }
        $this->date_end = $date_end;
        return $this;
    }
    /**
     * Get time_start value
     * @return string|null
     */
    public function getTime_start()
    {
        return $this->time_start;
    }
    /**
     * Set time_start value
     * @param string $time_start
     * @return \StructType\Limitation_period_type
     */
    public function setTime_start($time_start = null)
    {
        // validation for constraint: string
        if (!is_null($time_start) && !is_string($time_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_start, true), gettype($time_start)), __LINE__);
        }
        $this->time_start = $time_start;
        return $this;
    }
    /**
     * Get time_end value
     * @return string|null
     */
    public function getTime_end()
    {
        return $this->time_end;
    }
    /**
     * Set time_end value
     * @param string $time_end
     * @return \StructType\Limitation_period_type
     */
    public function setTime_end($time_end = null)
    {
        // validation for constraint: string
        if (!is_null($time_end) && !is_string($time_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_end, true), gettype($time_end)), __LINE__);
        }
        $this->time_end = $time_end;
        return $this;
    }
    /**
     * Get interval_code value
     * @return string|null
     */
    public function getInterval_code()
    {
        return $this->interval_code;
    }
    /**
     * Set interval_code value
     * @uses \EnumType\Interval_code_enum::valueIsValid()
     * @uses \EnumType\Interval_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interval_code
     * @return \StructType\Limitation_period_type
     */
    public function setInterval_code($interval_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Interval_code_enum::valueIsValid($interval_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Interval_code_enum', is_array($interval_code) ? implode(', ', $interval_code) : var_export($interval_code, true), implode(', ', \EnumType\Interval_code_enum::getValidValues())), __LINE__);
        }
        $this->interval_code = $interval_code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Limitation_period_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
