<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for icem_type StructType
 * @subpackage Structs
 */
class Icem_type extends AbstractStructBase
{
    /**
     * The internal_id
     * Meta information extracted from the WSDL
     * - documentation: Internal ID | Internal ID - best practice: global unique identifier
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $internal_id;
    /**
     * The nts_number
     * Meta information extracted from the WSDL
     * - documentation: NtS Number
     * @var \StructType\Nts_number_type
     */
    public $nts_number;
    /**
     * The validity_period
     * Meta information extracted from the WSDL
     * - documentation: Overall period of validity
     * @var \StructType\Validity_period_type
     */
    public $validity_period;
    /**
     * The fairway_section
     * Meta information extracted from the WSDL
     * - documentation: Fairway section - the limitation inside the fairway section cannot be used in the ICEM
     * @var \StructType\Fairway_section_type
     */
    public $fairway_section;
    /**
     * The ice_condition
     * Meta information extracted from the WSDL
     * - documentation: Ice conditions
     * - maxOccurs: unbounded
     * @var \StructType\Ice_condition_type[]
     */
    public $ice_condition;
    /**
     * Constructor method for icem_type
     * @uses Icem_type::setInternal_id()
     * @uses Icem_type::setNts_number()
     * @uses Icem_type::setValidity_period()
     * @uses Icem_type::setFairway_section()
     * @uses Icem_type::setIce_condition()
     * @param string $internal_id
     * @param \StructType\Nts_number_type $nts_number
     * @param \StructType\Validity_period_type $validity_period
     * @param \StructType\Fairway_section_type $fairway_section
     * @param \StructType\Ice_condition_type[] $ice_condition
     */
    public function __construct($internal_id = null, \StructType\Nts_number_type $nts_number = null, \StructType\Validity_period_type $validity_period = null, \StructType\Fairway_section_type $fairway_section = null, array $ice_condition = array())
    {
        $this
            ->setInternal_id($internal_id)
            ->setNts_number($nts_number)
            ->setValidity_period($validity_period)
            ->setFairway_section($fairway_section)
            ->setIce_condition($ice_condition);
    }
    /**
     * Get internal_id value
     * @return string|null
     */
    public function getInternal_id()
    {
        return $this->internal_id;
    }
    /**
     * Set internal_id value
     * @param string $internal_id
     * @return \StructType\Icem_type
     */
    public function setInternal_id($internal_id = null)
    {
        // validation for constraint: string
        if (!is_null($internal_id) && !is_string($internal_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_id, true), gettype($internal_id)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($internal_id) && mb_strlen($internal_id) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($internal_id)), __LINE__);
        }
        $this->internal_id = $internal_id;
        return $this;
    }
    /**
     * Get nts_number value
     * @return \StructType\Nts_number_type|null
     */
    public function getNts_number()
    {
        return $this->nts_number;
    }
    /**
     * Set nts_number value
     * @param \StructType\Nts_number_type $nts_number
     * @return \StructType\Icem_type
     */
    public function setNts_number(\StructType\Nts_number_type $nts_number = null)
    {
        $this->nts_number = $nts_number;
        return $this;
    }
    /**
     * Get validity_period value
     * @return \StructType\Validity_period_type|null
     */
    public function getValidity_period()
    {
        return $this->validity_period;
    }
    /**
     * Set validity_period value
     * @param \StructType\Validity_period_type $validity_period
     * @return \StructType\Icem_type
     */
    public function setValidity_period(\StructType\Validity_period_type $validity_period = null)
    {
        $this->validity_period = $validity_period;
        return $this;
    }
    /**
     * Get fairway_section value
     * @return \StructType\Fairway_section_type|null
     */
    public function getFairway_section()
    {
        return $this->fairway_section;
    }
    /**
     * Set fairway_section value
     * @param \StructType\Fairway_section_type $fairway_section
     * @return \StructType\Icem_type
     */
    public function setFairway_section(\StructType\Fairway_section_type $fairway_section = null)
    {
        $this->fairway_section = $fairway_section;
        return $this;
    }
    /**
     * Get ice_condition value
     * @return \StructType\Ice_condition_type[]|null
     */
    public function getIce_condition()
    {
        return $this->ice_condition;
    }
    /**
     * This method is responsible for validating the values passed to the setIce_condition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIce_condition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIce_conditionForArrayConstraintsFromSetIce_condition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $icem_typeIce_conditionItem) {
            // validation for constraint: itemType
            if (!$icem_typeIce_conditionItem instanceof \StructType\Ice_condition_type) {
                $invalidValues[] = is_object($icem_typeIce_conditionItem) ? get_class($icem_typeIce_conditionItem) : sprintf('%s(%s)', gettype($icem_typeIce_conditionItem), var_export($icem_typeIce_conditionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ice_condition property can only contain items of type \StructType\Ice_condition_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ice_condition value
     * @throws \InvalidArgumentException
     * @param \StructType\Ice_condition_type[] $ice_condition
     * @return \StructType\Icem_type
     */
    public function setIce_condition(array $ice_condition = array())
    {
        // validation for constraint: array
        if ('' !== ($ice_conditionArrayErrorMessage = self::validateIce_conditionForArrayConstraintsFromSetIce_condition($ice_condition))) {
            throw new \InvalidArgumentException($ice_conditionArrayErrorMessage, __LINE__);
        }
        $this->ice_condition = $ice_condition;
        return $this;
    }
    /**
     * Add item to ice_condition value
     * @throws \InvalidArgumentException
     * @param \StructType\Ice_condition_type $item
     * @return \StructType\Icem_type
     */
    public function addToIce_condition(\StructType\Ice_condition_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ice_condition_type) {
            throw new \InvalidArgumentException(sprintf('The ice_condition property can only contain items of type \StructType\Ice_condition_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ice_condition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Icem_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
