<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ice_condition_type StructType
 * @subpackage Structs
 */
class Ice_condition_type extends AbstractStructBase
{
    /**
     * The measuredate
     * Meta information extracted from the WSDL
     * - documentation: Date and Time of measurement or prediction including time zone
     * @var string
     */
    public $measuredate;
    /**
     * The ice_condition_code
     * Meta information extracted from the WSDL
     * - documentation: Condition code
     * - minOccurs: 0
     * @var string
     */
    public $ice_condition_code;
    /**
     * The ice_accessibility_code
     * Meta information extracted from the WSDL
     * - documentation: Accessibility code
     * - minOccurs: 0
     * @var string
     */
    public $ice_accessibility_code;
    /**
     * The ice_classification_code
     * Meta information extracted from the WSDL
     * - documentation: Classification code
     * - minOccurs: 0
     * @var string
     */
    public $ice_classification_code;
    /**
     * The ice_situation_code
     * Meta information extracted from the WSDL
     * - documentation: Situation code
     * - minOccurs: 0
     * @var string
     */
    public $ice_situation_code;
    /**
     * Constructor method for ice_condition_type
     * @uses Ice_condition_type::setMeasuredate()
     * @uses Ice_condition_type::setIce_condition_code()
     * @uses Ice_condition_type::setIce_accessibility_code()
     * @uses Ice_condition_type::setIce_classification_code()
     * @uses Ice_condition_type::setIce_situation_code()
     * @param string $measuredate
     * @param string $ice_condition_code
     * @param string $ice_accessibility_code
     * @param string $ice_classification_code
     * @param string $ice_situation_code
     */
    public function __construct($measuredate = null, $ice_condition_code = null, $ice_accessibility_code = null, $ice_classification_code = null, $ice_situation_code = null)
    {
        $this
            ->setMeasuredate($measuredate)
            ->setIce_condition_code($ice_condition_code)
            ->setIce_accessibility_code($ice_accessibility_code)
            ->setIce_classification_code($ice_classification_code)
            ->setIce_situation_code($ice_situation_code);
    }
    /**
     * Get measuredate value
     * @return string|null
     */
    public function getMeasuredate()
    {
        return $this->measuredate;
    }
    /**
     * Set measuredate value
     * @param string $measuredate
     * @return \StructType\Ice_condition_type
     */
    public function setMeasuredate($measuredate = null)
    {
        // validation for constraint: string
        if (!is_null($measuredate) && !is_string($measuredate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measuredate, true), gettype($measuredate)), __LINE__);
        }
        $this->measuredate = $measuredate;
        return $this;
    }
    /**
     * Get ice_condition_code value
     * @return string|null
     */
    public function getIce_condition_code()
    {
        return $this->ice_condition_code;
    }
    /**
     * Set ice_condition_code value
     * @uses \EnumType\Ice_condition_code_enum::valueIsValid()
     * @uses \EnumType\Ice_condition_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ice_condition_code
     * @return \StructType\Ice_condition_type
     */
    public function setIce_condition_code($ice_condition_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Ice_condition_code_enum::valueIsValid($ice_condition_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Ice_condition_code_enum', is_array($ice_condition_code) ? implode(', ', $ice_condition_code) : var_export($ice_condition_code, true), implode(', ', \EnumType\Ice_condition_code_enum::getValidValues())), __LINE__);
        }
        $this->ice_condition_code = $ice_condition_code;
        return $this;
    }
    /**
     * Get ice_accessibility_code value
     * @return string|null
     */
    public function getIce_accessibility_code()
    {
        return $this->ice_accessibility_code;
    }
    /**
     * Set ice_accessibility_code value
     * @uses \EnumType\Ice_accessibility_code_enum::valueIsValid()
     * @uses \EnumType\Ice_accessibility_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ice_accessibility_code
     * @return \StructType\Ice_condition_type
     */
    public function setIce_accessibility_code($ice_accessibility_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Ice_accessibility_code_enum::valueIsValid($ice_accessibility_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Ice_accessibility_code_enum', is_array($ice_accessibility_code) ? implode(', ', $ice_accessibility_code) : var_export($ice_accessibility_code, true), implode(', ', \EnumType\Ice_accessibility_code_enum::getValidValues())), __LINE__);
        }
        $this->ice_accessibility_code = $ice_accessibility_code;
        return $this;
    }
    /**
     * Get ice_classification_code value
     * @return string|null
     */
    public function getIce_classification_code()
    {
        return $this->ice_classification_code;
    }
    /**
     * Set ice_classification_code value
     * @uses \EnumType\Ice_classification_code_enum::valueIsValid()
     * @uses \EnumType\Ice_classification_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ice_classification_code
     * @return \StructType\Ice_condition_type
     */
    public function setIce_classification_code($ice_classification_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Ice_classification_code_enum::valueIsValid($ice_classification_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Ice_classification_code_enum', is_array($ice_classification_code) ? implode(', ', $ice_classification_code) : var_export($ice_classification_code, true), implode(', ', \EnumType\Ice_classification_code_enum::getValidValues())), __LINE__);
        }
        $this->ice_classification_code = $ice_classification_code;
        return $this;
    }
    /**
     * Get ice_situation_code value
     * @return string|null
     */
    public function getIce_situation_code()
    {
        return $this->ice_situation_code;
    }
    /**
     * Set ice_situation_code value
     * @uses \EnumType\Ice_situation_code_enum::valueIsValid()
     * @uses \EnumType\Ice_situation_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ice_situation_code
     * @return \StructType\Ice_condition_type
     */
    public function setIce_situation_code($ice_situation_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Ice_situation_code_enum::valueIsValid($ice_situation_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Ice_situation_code_enum', is_array($ice_situation_code) ? implode(', ', $ice_situation_code) : var_export($ice_situation_code, true), implode(', ', \EnumType\Ice_situation_code_enum::getValidValues())), __LINE__);
        }
        $this->ice_situation_code = $ice_situation_code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ice_condition_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
