<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for get_messages_query StructType
 * @subpackage Structs
 */
class Get_messages_query extends AbstractStructBase
{
    /**
     * The message_type
     * @var string
     */
    public $message_type;
    /**
     * The ids
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Id_pair[]
     */
    public $ids;
    /**
     * The validity_period
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Validity_period_type
     */
    public $validity_period;
    /**
     * Constructor method for get_messages_query
     * @uses Get_messages_query::setMessage_type()
     * @uses Get_messages_query::setIds()
     * @uses Get_messages_query::setValidity_period()
     * @param string $message_type
     * @param \StructType\Id_pair[] $ids
     * @param \StructType\Validity_period_type $validity_period
     */
    public function __construct($message_type = null, array $ids = array(), \StructType\Validity_period_type $validity_period = null)
    {
        $this
            ->setMessage_type($message_type)
            ->setIds($ids)
            ->setValidity_period($validity_period);
    }
    /**
     * Get message_type value
     * @return string|null
     */
    public function getMessage_type()
    {
        return $this->message_type;
    }
    /**
     * Set message_type value
     * @uses \EnumType\Message_type_type::valueIsValid()
     * @uses \EnumType\Message_type_type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $message_type
     * @return \StructType\Get_messages_query
     */
    public function setMessage_type($message_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Message_type_type::valueIsValid($message_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Message_type_type', is_array($message_type) ? implode(', ', $message_type) : var_export($message_type, true), implode(', ', \EnumType\Message_type_type::getValidValues())), __LINE__);
        }
        $this->message_type = $message_type;
        return $this;
    }
    /**
     * Get ids value
     * @return \StructType\Id_pair[]|null
     */
    public function getIds()
    {
        return $this->ids;
    }
    /**
     * This method is responsible for validating the values passed to the setIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdsForArrayConstraintsFromSetIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $get_messages_queryIdsItem) {
            // validation for constraint: itemType
            if (!$get_messages_queryIdsItem instanceof \StructType\Id_pair) {
                $invalidValues[] = is_object($get_messages_queryIdsItem) ? get_class($get_messages_queryIdsItem) : sprintf('%s(%s)', gettype($get_messages_queryIdsItem), var_export($get_messages_queryIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ids property can only contain items of type \StructType\Id_pair, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ids value
     * @throws \InvalidArgumentException
     * @param \StructType\Id_pair[] $ids
     * @return \StructType\Get_messages_query
     */
    public function setIds(array $ids = array())
    {
        // validation for constraint: array
        if ('' !== ($idsArrayErrorMessage = self::validateIdsForArrayConstraintsFromSetIds($ids))) {
            throw new \InvalidArgumentException($idsArrayErrorMessage, __LINE__);
        }
        $this->ids = $ids;
        return $this;
    }
    /**
     * Add item to ids value
     * @throws \InvalidArgumentException
     * @param \StructType\Id_pair $item
     * @return \StructType\Get_messages_query
     */
    public function addToIds(\StructType\Id_pair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Id_pair) {
            throw new \InvalidArgumentException(sprintf('The ids property can only contain items of type \StructType\Id_pair, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ids[] = $item;
        return $this;
    }
    /**
     * Get validity_period value
     * @return \StructType\Validity_period_type|null
     */
    public function getValidity_period()
    {
        return $this->validity_period;
    }
    /**
     * Set validity_period value
     * @param \StructType\Validity_period_type $validity_period
     * @return \StructType\Get_messages_query
     */
    public function setValidity_period(\StructType\Validity_period_type $validity_period = null)
    {
        $this->validity_period = $validity_period;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Get_messages_query
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
