<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for geo_object_type StructType
 * @subpackage Structs
 */
class Geo_object_type extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: ISRS Location Code of the fairway/object | ISRS location code, unique identification of the geo object as defined in RIS Index encoding guide
     * - base: xs:string
     * - length: 20
     * - maxOccurs: 2
     * - pattern: [A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}
     * @var string[]
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Local name of the fairway section
     * - base: xs:string
     * - maxLength: 256
     * @var string
     */
    public $name;
    /**
     * The type_code
     * Meta information extracted from the WSDL
     * - documentation: Type of geographical object
     * - default: FWY
     * @var string
     */
    public $type_code;
    /**
     * The position_code
     * Meta information extracted from the WSDL
     * - documentation: Describes the position related to the fairway
     * - minOccurs: 0
     * @var string
     */
    public $position_code;
    /**
     * The coordinate
     * Meta information extracted from the WSDL
     * - documentation: Fairway section begin and end coordinates
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\Coordinate_type[]
     */
    public $coordinate;
    /**
     * The fairway_name
     * Meta information extracted from the WSDL
     * - documentation: Waterway name (usefull if no RIS Index is available)
     * - base: xs:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $fairway_name;
    /**
     * Constructor method for geo_object_type
     * @uses Geo_object_type::setId()
     * @uses Geo_object_type::setName()
     * @uses Geo_object_type::setType_code()
     * @uses Geo_object_type::setPosition_code()
     * @uses Geo_object_type::setCoordinate()
     * @uses Geo_object_type::setFairway_name()
     * @param string[] $id
     * @param string $name
     * @param string $type_code
     * @param string $position_code
     * @param \StructType\Coordinate_type[] $coordinate
     * @param string $fairway_name
     */
    public function __construct(array $id = array(), $name = null, $type_code = 'FWY', $position_code = null, array $coordinate = array(), $fairway_name = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setType_code($type_code)
            ->setPosition_code($position_code)
            ->setCoordinate($coordinate)
            ->setFairway_name($fairway_name);
    }
    /**
     * Get id value
     * @return string[]|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * This method is responsible for validating the values passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForArrayConstraintsFromSetId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $geo_object_typeIdItem) {
            // validation for constraint: itemType
            if (!is_string($geo_object_typeIdItem)) {
                $invalidValues[] = is_object($geo_object_typeIdItem) ? get_class($geo_object_typeIdItem) : sprintf('%s(%s)', gettype($geo_object_typeIdItem), var_export($geo_object_typeIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The id property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setId method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdForLengthConstraintFromSetId($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $geo_object_typeIdItem) {
            // validation for constraint: length(20)
            if (mb_strlen($geo_object_typeIdItem) !== 20) {
                $invalidValues[] = var_export($geo_object_typeIdItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 20', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set id value
     * @throws \InvalidArgumentException
     * @param string[] $id
     * @return \StructType\Geo_object_type
     */
    public function setId(array $id = array())
    {
        // validation for constraint: array
        if ('' !== ($idArrayErrorMessage = self::validateIdForArrayConstraintsFromSetId($id))) {
            throw new \InvalidArgumentException($idArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(20)
        if ('' !== ($idLengthErrorMessage = self::validateIdForLengthConstraintFromSetId($id))) {
            throw new \InvalidArgumentException($idLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($id) && count($id) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($id)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5})
        if (!is_null($id) && !preg_match('/[A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}', var_export($id, true)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Add item to id value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Geo_object_type
     */
    public function addToId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The id property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(20)
        if (mb_strlen($item) !== 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 20', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->id) && count($this->id) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->id)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5})
        if (!preg_match('/[A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}[A-Z]{3}[A-Z0-9]{5}[A-Z0-9]{5}[0-9]{5}', var_export($item, true)), __LINE__);
        }
        $this->id[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Geo_object_type
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($name) && mb_strlen($name) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type_code value
     * @return string|null
     */
    public function getType_code()
    {
        return $this->type_code;
    }
    /**
     * Set type_code value
     * @uses \EnumType\Type_code_enum::valueIsValid()
     * @uses \EnumType\Type_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type_code
     * @return \StructType\Geo_object_type
     */
    public function setType_code($type_code = 'FWY')
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type_code_enum::valueIsValid($type_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Type_code_enum', is_array($type_code) ? implode(', ', $type_code) : var_export($type_code, true), implode(', ', \EnumType\Type_code_enum::getValidValues())), __LINE__);
        }
        $this->type_code = $type_code;
        return $this;
    }
    /**
     * Get position_code value
     * @return string|null
     */
    public function getPosition_code()
    {
        return $this->position_code;
    }
    /**
     * Set position_code value
     * @uses \EnumType\Position_code_enum::valueIsValid()
     * @uses \EnumType\Position_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $position_code
     * @return \StructType\Geo_object_type
     */
    public function setPosition_code($position_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Position_code_enum::valueIsValid($position_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Position_code_enum', is_array($position_code) ? implode(', ', $position_code) : var_export($position_code, true), implode(', ', \EnumType\Position_code_enum::getValidValues())), __LINE__);
        }
        $this->position_code = $position_code;
        return $this;
    }
    /**
     * Get coordinate value
     * @return \StructType\Coordinate_type[]|null
     */
    public function getCoordinate()
    {
        return $this->coordinate;
    }
    /**
     * This method is responsible for validating the values passed to the setCoordinate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoordinate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoordinateForArrayConstraintsFromSetCoordinate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $geo_object_typeCoordinateItem) {
            // validation for constraint: itemType
            if (!$geo_object_typeCoordinateItem instanceof \StructType\Coordinate_type) {
                $invalidValues[] = is_object($geo_object_typeCoordinateItem) ? get_class($geo_object_typeCoordinateItem) : sprintf('%s(%s)', gettype($geo_object_typeCoordinateItem), var_export($geo_object_typeCoordinateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The coordinate property can only contain items of type \StructType\Coordinate_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set coordinate value
     * @throws \InvalidArgumentException
     * @param \StructType\Coordinate_type[] $coordinate
     * @return \StructType\Geo_object_type
     */
    public function setCoordinate(array $coordinate = array())
    {
        // validation for constraint: array
        if ('' !== ($coordinateArrayErrorMessage = self::validateCoordinateForArrayConstraintsFromSetCoordinate($coordinate))) {
            throw new \InvalidArgumentException($coordinateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($coordinate) && count($coordinate) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($coordinate)), __LINE__);
        }
        $this->coordinate = $coordinate;
        return $this;
    }
    /**
     * Add item to coordinate value
     * @throws \InvalidArgumentException
     * @param \StructType\Coordinate_type $item
     * @return \StructType\Geo_object_type
     */
    public function addToCoordinate(\StructType\Coordinate_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Coordinate_type) {
            throw new \InvalidArgumentException(sprintf('The coordinate property can only contain items of type \StructType\Coordinate_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->coordinate) && count($this->coordinate) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->coordinate)), __LINE__);
        }
        $this->coordinate[] = $item;
        return $this;
    }
    /**
     * Get fairway_name value
     * @return string|null
     */
    public function getFairway_name()
    {
        return $this->fairway_name;
    }
    /**
     * Set fairway_name value
     * @param string $fairway_name
     * @return \StructType\Geo_object_type
     */
    public function setFairway_name($fairway_name = null)
    {
        // validation for constraint: string
        if (!is_null($fairway_name) && !is_string($fairway_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fairway_name, true), gettype($fairway_name)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($fairway_name) && mb_strlen($fairway_name) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($fairway_name)), __LINE__);
        }
        $this->fairway_name = $fairway_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Geo_object_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
