<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ftm_type StructType
 * @subpackage Structs
 */
class Ftm_type extends AbstractStructBase
{
    /**
     * The internal_id
     * Meta information extracted from the WSDL
     * - documentation: Internal ID | Internal ID - best practice: global unique identifier
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $internal_id;
    /**
     * The nts_number
     * Meta information extracted from the WSDL
     * - documentation: NtS Number
     * @var \StructType\Nts_number_type
     */
    public $nts_number;
    /**
     * The target_group
     * Meta information extracted from the WSDL
     * - documentation: Target group information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Target_group_type[]
     */
    public $target_group;
    /**
     * The subject_code
     * Meta information extracted from the WSDL
     * - documentation: Subject code must contain one of the following: Announcement (ANNOUN), Warning (WARNIN), Notice withdrawn (CANCEL) or Information service (INFSER). More information on the use of codes can be found in the NtS Encoding Guide.
     * @var string
     */
    public $subject_code;
    /**
     * The validity_period
     * Meta information extracted from the WSDL
     * - documentation: Overall period of validity
     * @var \StructType\Validity_period_type
     */
    public $validity_period;
    /**
     * The contents
     * Meta information extracted from the WSDL
     * - documentation: Additional information in local language
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $contents;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - documentation: Notice source (name of authority)
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The reason_code
     * Meta information extracted from the WSDL
     * - documentation: Reason / justification of the notice
     * - minOccurs: 0
     * @var string
     */
    public $reason_code;
    /**
     * The communication
     * Meta information extracted from the WSDL
     * - documentation: Communication channel information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Communication_type[]
     */
    public $communication;
    /**
     * The fairway_section
     * Meta information extracted from the WSDL
     * - documentation: Fairway section
     * - choice: fairway_section | object
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * @var \StructType\Fairway_section_type
     */
    public $fairway_section;
    /**
     * The object
     * Meta information extracted from the WSDL
     * - documentation: Object section
     * - choice: fairway_section | object
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * @var \StructType\Object_type
     */
    public $object;
    /**
     * Constructor method for ftm_type
     * @uses Ftm_type::setInternal_id()
     * @uses Ftm_type::setNts_number()
     * @uses Ftm_type::setTarget_group()
     * @uses Ftm_type::setSubject_code()
     * @uses Ftm_type::setValidity_period()
     * @uses Ftm_type::setContents()
     * @uses Ftm_type::setSource()
     * @uses Ftm_type::setReason_code()
     * @uses Ftm_type::setCommunication()
     * @uses Ftm_type::setFairway_section()
     * @uses Ftm_type::setObject()
     * @param string $internal_id
     * @param \StructType\Nts_number_type $nts_number
     * @param \StructType\Target_group_type[] $target_group
     * @param string $subject_code
     * @param \StructType\Validity_period_type $validity_period
     * @param string $contents
     * @param string $source
     * @param string $reason_code
     * @param \StructType\Communication_type[] $communication
     * @param \StructType\Fairway_section_type $fairway_section
     * @param \StructType\Object_type $object
     */
    public function __construct($internal_id = null, \StructType\Nts_number_type $nts_number = null, array $target_group = array(), $subject_code = null, \StructType\Validity_period_type $validity_period = null, $contents = null, $source = null, $reason_code = null, array $communication = array(), \StructType\Fairway_section_type $fairway_section = null, \StructType\Object_type $object = null)
    {
        $this
            ->setInternal_id($internal_id)
            ->setNts_number($nts_number)
            ->setTarget_group($target_group)
            ->setSubject_code($subject_code)
            ->setValidity_period($validity_period)
            ->setContents($contents)
            ->setSource($source)
            ->setReason_code($reason_code)
            ->setCommunication($communication)
            ->setFairway_section($fairway_section)
            ->setObject($object);
    }
    /**
     * Get internal_id value
     * @return string|null
     */
    public function getInternal_id()
    {
        return $this->internal_id;
    }
    /**
     * Set internal_id value
     * @param string $internal_id
     * @return \StructType\Ftm_type
     */
    public function setInternal_id($internal_id = null)
    {
        // validation for constraint: string
        if (!is_null($internal_id) && !is_string($internal_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_id, true), gettype($internal_id)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($internal_id) && mb_strlen($internal_id) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($internal_id)), __LINE__);
        }
        $this->internal_id = $internal_id;
        return $this;
    }
    /**
     * Get nts_number value
     * @return \StructType\Nts_number_type|null
     */
    public function getNts_number()
    {
        return $this->nts_number;
    }
    /**
     * Set nts_number value
     * @param \StructType\Nts_number_type $nts_number
     * @return \StructType\Ftm_type
     */
    public function setNts_number(\StructType\Nts_number_type $nts_number = null)
    {
        $this->nts_number = $nts_number;
        return $this;
    }
    /**
     * Get target_group value
     * @return \StructType\Target_group_type[]|null
     */
    public function getTarget_group()
    {
        return $this->target_group;
    }
    /**
     * This method is responsible for validating the values passed to the setTarget_group method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTarget_group method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTarget_groupForArrayConstraintsFromSetTarget_group(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ftm_typeTarget_groupItem) {
            // validation for constraint: itemType
            if (!$ftm_typeTarget_groupItem instanceof \StructType\Target_group_type) {
                $invalidValues[] = is_object($ftm_typeTarget_groupItem) ? get_class($ftm_typeTarget_groupItem) : sprintf('%s(%s)', gettype($ftm_typeTarget_groupItem), var_export($ftm_typeTarget_groupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The target_group property can only contain items of type \StructType\Target_group_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set target_group value
     * @throws \InvalidArgumentException
     * @param \StructType\Target_group_type[] $target_group
     * @return \StructType\Ftm_type
     */
    public function setTarget_group(array $target_group = array())
    {
        // validation for constraint: array
        if ('' !== ($target_groupArrayErrorMessage = self::validateTarget_groupForArrayConstraintsFromSetTarget_group($target_group))) {
            throw new \InvalidArgumentException($target_groupArrayErrorMessage, __LINE__);
        }
        $this->target_group = $target_group;
        return $this;
    }
    /**
     * Add item to target_group value
     * @throws \InvalidArgumentException
     * @param \StructType\Target_group_type $item
     * @return \StructType\Ftm_type
     */
    public function addToTarget_group(\StructType\Target_group_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Target_group_type) {
            throw new \InvalidArgumentException(sprintf('The target_group property can only contain items of type \StructType\Target_group_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->target_group[] = $item;
        return $this;
    }
    /**
     * Get subject_code value
     * @return string|null
     */
    public function getSubject_code()
    {
        return $this->subject_code;
    }
    /**
     * Set subject_code value
     * @uses \EnumType\Subject_code_enum::valueIsValid()
     * @uses \EnumType\Subject_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subject_code
     * @return \StructType\Ftm_type
     */
    public function setSubject_code($subject_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Subject_code_enum::valueIsValid($subject_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Subject_code_enum', is_array($subject_code) ? implode(', ', $subject_code) : var_export($subject_code, true), implode(', ', \EnumType\Subject_code_enum::getValidValues())), __LINE__);
        }
        $this->subject_code = $subject_code;
        return $this;
    }
    /**
     * Get validity_period value
     * @return \StructType\Validity_period_type|null
     */
    public function getValidity_period()
    {
        return $this->validity_period;
    }
    /**
     * Set validity_period value
     * @param \StructType\Validity_period_type $validity_period
     * @return \StructType\Ftm_type
     */
    public function setValidity_period(\StructType\Validity_period_type $validity_period = null)
    {
        $this->validity_period = $validity_period;
        return $this;
    }
    /**
     * Get contents value
     * @return string|null
     */
    public function getContents()
    {
        return $this->contents;
    }
    /**
     * Set contents value
     * @param string $contents
     * @return \StructType\Ftm_type
     */
    public function setContents($contents = null)
    {
        // validation for constraint: string
        if (!is_null($contents) && !is_string($contents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contents, true), gettype($contents)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($contents) && mb_strlen($contents) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($contents)), __LINE__);
        }
        $this->contents = $contents;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\Ftm_type
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($source) && mb_strlen($source) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get reason_code value
     * @return string|null
     */
    public function getReason_code()
    {
        return $this->reason_code;
    }
    /**
     * Set reason_code value
     * @uses \EnumType\Reason_code_enum::valueIsValid()
     * @uses \EnumType\Reason_code_enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reason_code
     * @return \StructType\Ftm_type
     */
    public function setReason_code($reason_code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Reason_code_enum::valueIsValid($reason_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Reason_code_enum', is_array($reason_code) ? implode(', ', $reason_code) : var_export($reason_code, true), implode(', ', \EnumType\Reason_code_enum::getValidValues())), __LINE__);
        }
        $this->reason_code = $reason_code;
        return $this;
    }
    /**
     * Get communication value
     * @return \StructType\Communication_type[]|null
     */
    public function getCommunication()
    {
        return $this->communication;
    }
    /**
     * This method is responsible for validating the values passed to the setCommunication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommunicationForArrayConstraintsFromSetCommunication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ftm_typeCommunicationItem) {
            // validation for constraint: itemType
            if (!$ftm_typeCommunicationItem instanceof \StructType\Communication_type) {
                $invalidValues[] = is_object($ftm_typeCommunicationItem) ? get_class($ftm_typeCommunicationItem) : sprintf('%s(%s)', gettype($ftm_typeCommunicationItem), var_export($ftm_typeCommunicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The communication property can only contain items of type \StructType\Communication_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set communication value
     * @throws \InvalidArgumentException
     * @param \StructType\Communication_type[] $communication
     * @return \StructType\Ftm_type
     */
    public function setCommunication(array $communication = array())
    {
        // validation for constraint: array
        if ('' !== ($communicationArrayErrorMessage = self::validateCommunicationForArrayConstraintsFromSetCommunication($communication))) {
            throw new \InvalidArgumentException($communicationArrayErrorMessage, __LINE__);
        }
        $this->communication = $communication;
        return $this;
    }
    /**
     * Add item to communication value
     * @throws \InvalidArgumentException
     * @param \StructType\Communication_type $item
     * @return \StructType\Ftm_type
     */
    public function addToCommunication(\StructType\Communication_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Communication_type) {
            throw new \InvalidArgumentException(sprintf('The communication property can only contain items of type \StructType\Communication_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->communication[] = $item;
        return $this;
    }
    /**
     * Get fairway_section value
     * @return \StructType\Fairway_section_type|null
     */
    public function getFairway_section()
    {
        return isset($this->fairway_section) ? $this->fairway_section : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFairway_section method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFairway_section method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFairway_sectionForChoiceConstraintsFromSetFairway_section($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'object',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property fairway_section can\'t be set as the property %s is already set. Only one property must be set among these properties: fairway_section, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set fairway_section value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Fairway_section_type $fairway_section
     * @return \StructType\Ftm_type
     */
    public function setFairway_section(\StructType\Fairway_section_type $fairway_section = null)
    {
        // validation for constraint: choice(fairway_section, object)
        if ('' !== ($fairway_sectionChoiceErrorMessage = self::validateFairway_sectionForChoiceConstraintsFromSetFairway_section($fairway_section))) {
            throw new \InvalidArgumentException($fairway_sectionChoiceErrorMessage, __LINE__);
        }
        if (is_null($fairway_section) || (is_array($fairway_section) && empty($fairway_section))) {
            unset($this->fairway_section);
        } else {
            $this->fairway_section = $fairway_section;
        }
        return $this;
    }
    /**
     * Get object value
     * @return \StructType\Object_type|null
     */
    public function getObject()
    {
        return isset($this->object) ? $this->object : null;
    }
    /**
     * This method is responsible for validating the value passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateObjectForChoiceConstraintsFromSetObject($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'fairway_section',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property object can\'t be set as the property %s is already set. Only one property must be set among these properties: object, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set object value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Object_type $object
     * @return \StructType\Ftm_type
     */
    public function setObject(\StructType\Object_type $object = null)
    {
        // validation for constraint: choice(fairway_section, object)
        if ('' !== ($objectChoiceErrorMessage = self::validateObjectForChoiceConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectChoiceErrorMessage, __LINE__);
        }
        if (is_null($object) || (is_array($object) && empty($object))) {
            unset($this->object);
        } else {
            $this->object = $object;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ftm_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
