<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for difference_type StructType
 * @subpackage Structs
 */
class Difference_type extends AbstractStructBase
{
    /**
     * The value_difference
     * Meta information extracted from the WSDL
     * - documentation: Difference with comparative value
     * @var float
     */
    public $value_difference;
    /**
     * The time_difference
     * Meta information extracted from the WSDL
     * - documentation: Time difference with measuredata of comparative measurement
     * @var string
     */
    public $time_difference;
    /**
     * Constructor method for difference_type
     * @uses Difference_type::setValue_difference()
     * @uses Difference_type::setTime_difference()
     * @param float $value_difference
     * @param string $time_difference
     */
    public function __construct($value_difference = null, $time_difference = null)
    {
        $this
            ->setValue_difference($value_difference)
            ->setTime_difference($time_difference);
    }
    /**
     * Get value_difference value
     * @return float|null
     */
    public function getValue_difference()
    {
        return $this->value_difference;
    }
    /**
     * Set value_difference value
     * @param float $value_difference
     * @return \StructType\Difference_type
     */
    public function setValue_difference($value_difference = null)
    {
        // validation for constraint: float
        if (!is_null($value_difference) && !(is_float($value_difference) || is_numeric($value_difference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value_difference, true), gettype($value_difference)), __LINE__);
        }
        $this->value_difference = $value_difference;
        return $this;
    }
    /**
     * Get time_difference value
     * @return string|null
     */
    public function getTime_difference()
    {
        return $this->time_difference;
    }
    /**
     * Set time_difference value
     * @param string $time_difference
     * @return \StructType\Difference_type
     */
    public function setTime_difference($time_difference = null)
    {
        // validation for constraint: string
        if (!is_null($time_difference) && !is_string($time_difference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_difference, true), gettype($time_difference)), __LINE__);
        }
        $this->time_difference = $time_difference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Difference_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
