<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for coordinate_type StructType
 * @subpackage Structs
 */
class Coordinate_type extends AbstractStructBase
{
    /**
     * The lat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 12
     * - minLength: 10
     * @var string
     */
    public $lat;
    /**
     * The long
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 13
     * - minLength: 10
     * @var string
     */
    public $long;
    /**
     * Constructor method for coordinate_type
     * @uses Coordinate_type::setLat()
     * @uses Coordinate_type::setLong()
     * @param string $lat
     * @param string $long
     */
    public function __construct($lat = null, $long = null)
    {
        $this
            ->setLat($lat)
            ->setLong($long);
    }
    /**
     * Get lat value
     * @return string|null
     */
    public function getLat()
    {
        return $this->lat;
    }
    /**
     * Set lat value
     * @param string $lat
     * @return \StructType\Coordinate_type
     */
    public function setLat($lat = null)
    {
        // validation for constraint: string
        if (!is_null($lat) && !is_string($lat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lat, true), gettype($lat)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($lat) && mb_strlen($lat) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($lat)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($lat) && mb_strlen($lat) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($lat)), __LINE__);
        }
        $this->lat = $lat;
        return $this;
    }
    /**
     * Get long value
     * @return string|null
     */
    public function getLong()
    {
        return $this->long;
    }
    /**
     * Set long value
     * @param string $long
     * @return \StructType\Coordinate_type
     */
    public function setLong($long = null)
    {
        // validation for constraint: string
        if (!is_null($long) && !is_string($long)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($long, true), gettype($long)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($long) && mb_strlen($long) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($long)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($long) && mb_strlen($long) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($long)), __LINE__);
        }
        $this->long = $long;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Coordinate_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
