<?php

namespace EnumType;

/**
 * This class stands for weather_item_code_enum EnumType
 * @subpackage Enumerations
 */
class Weather_item_code_enum
{
    /**
     * Constant for value 'WI'
     * @return string 'WI'
     */
    const VALUE_WI = 'WI';
    /**
     * Constant for value 'WA'
     * @return string 'WA'
     */
    const VALUE_WA = 'WA';
    /**
     * Constant for value 'FG'
     * @return string 'FG'
     */
    const VALUE_FG = 'FG';
    /**
     * Constant for value 'RN'
     * @return string 'RN'
     */
    const VALUE_RN = 'RN';
    /**
     * Constant for value 'SN'
     * @return string 'SN'
     */
    const VALUE_SN = 'SN';
    /**
     * Constant for value 'AT'
     * @return string 'AT'
     */
    const VALUE_AT = 'AT';
    /**
     * Constant for value 'WT'
     * @return string 'WT'
     */
    const VALUE_WT = 'WT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WI
     * @uses self::VALUE_WA
     * @uses self::VALUE_FG
     * @uses self::VALUE_RN
     * @uses self::VALUE_SN
     * @uses self::VALUE_AT
     * @uses self::VALUE_WT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WI,
            self::VALUE_WA,
            self::VALUE_FG,
            self::VALUE_RN,
            self::VALUE_SN,
            self::VALUE_AT,
            self::VALUE_WT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
