<?php

namespace EnumType;

/**
 * This class stands for weather_direction_code_enum EnumType
 * @subpackage Enumerations
 */
class Weather_direction_code_enum
{
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Constant for value 'NE'
     * @return string 'NE'
     */
    const VALUE_NE = 'NE';
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'SE'
     * @return string 'SE'
     */
    const VALUE_SE = 'SE';
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'SW'
     * @return string 'SW'
     */
    const VALUE_SW = 'SW';
    /**
     * Constant for value 'W'
     * @return string 'W'
     */
    const VALUE_W = 'W';
    /**
     * Constant for value 'NW'
     * @return string 'NW'
     */
    const VALUE_NW = 'NW';
    /**
     * Constant for value 'WRB'
     * @return string 'WRB'
     */
    const VALUE_WRB = 'WRB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_N
     * @uses self::VALUE_NE
     * @uses self::VALUE_E
     * @uses self::VALUE_SE
     * @uses self::VALUE_S
     * @uses self::VALUE_SW
     * @uses self::VALUE_W
     * @uses self::VALUE_NW
     * @uses self::VALUE_WRB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_N,
            self::VALUE_NE,
            self::VALUE_E,
            self::VALUE_SE,
            self::VALUE_S,
            self::VALUE_SW,
            self::VALUE_W,
            self::VALUE_NW,
            self::VALUE_WRB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
