<?php

namespace EnumType;

/**
 * This class stands for weather_class_code_enum EnumType
 * @subpackage Enumerations
 */
class Weather_class_code_enum
{
    /**
     * Constant for value 'CLR'
     * @return string 'CLR'
     */
    const VALUE_CLR = 'CLR';
    /**
     * Constant for value 'CLDY'
     * @return string 'CLDY'
     */
    const VALUE_CLDY = 'CLDY';
    /**
     * Constant for value 'OCST'
     * @return string 'OCST'
     */
    const VALUE_OCST = 'OCST';
    /**
     * Constant for value 'DZZL'
     * @return string 'DZZL'
     */
    const VALUE_DZZL = 'DZZL';
    /**
     * Constant for value 'RAIN'
     * @return string 'RAIN'
     */
    const VALUE_RAIN = 'RAIN';
    /**
     * Constant for value 'LRAIN'
     * @return string 'LRAIN'
     */
    const VALUE_LRAIN = 'LRAIN';
    /**
     * Constant for value 'ORAIN'
     * @return string 'ORAIN'
     */
    const VALUE_ORAIN = 'ORAIN';
    /**
     * Constant for value 'HRAIN'
     * @return string 'HRAIN'
     */
    const VALUE_HRAIN = 'HRAIN';
    /**
     * Constant for value 'SLEET'
     * @return string 'SLEET'
     */
    const VALUE_SLEET = 'SLEET';
    /**
     * Constant for value 'SNOW'
     * @return string 'SNOW'
     */
    const VALUE_SNOW = 'SNOW';
    /**
     * Constant for value 'SNFALL'
     * @return string 'SNFALL'
     */
    const VALUE_SNFALL = 'SNFALL';
    /**
     * Constant for value 'HAIL'
     * @return string 'HAIL'
     */
    const VALUE_HAIL = 'HAIL';
    /**
     * Constant for value 'SHWRS'
     * @return string 'SHWRS'
     */
    const VALUE_SHWRS = 'SHWRS';
    /**
     * Constant for value 'THSTRM'
     * @return string 'THSTRM'
     */
    const VALUE_THSTRM = 'THSTRM';
    /**
     * Constant for value 'HAZY'
     * @return string 'HAZY'
     */
    const VALUE_HAZY = 'HAZY';
    /**
     * Constant for value 'FOG'
     * @return string 'FOG'
     */
    const VALUE_FOG = 'FOG';
    /**
     * Constant for value 'FOGPAT'
     * @return string 'FOGPAT'
     */
    const VALUE_FOGPAT = 'FOGPAT';
    /**
     * Constant for value 'GALE'
     * @return string 'GALE'
     */
    const VALUE_GALE = 'GALE';
    /**
     * Constant for value 'STRM'
     * @return string 'STRM'
     */
    const VALUE_STRM = 'STRM';
    /**
     * Constant for value 'HURRC'
     * @return string 'HURRC'
     */
    const VALUE_HURRC = 'HURRC';
    /**
     * Constant for value 'FZRA'
     * @return string 'FZRA'
     */
    const VALUE_FZRA = 'FZRA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLR
     * @uses self::VALUE_CLDY
     * @uses self::VALUE_OCST
     * @uses self::VALUE_DZZL
     * @uses self::VALUE_RAIN
     * @uses self::VALUE_LRAIN
     * @uses self::VALUE_ORAIN
     * @uses self::VALUE_HRAIN
     * @uses self::VALUE_SLEET
     * @uses self::VALUE_SNOW
     * @uses self::VALUE_SNFALL
     * @uses self::VALUE_HAIL
     * @uses self::VALUE_SHWRS
     * @uses self::VALUE_THSTRM
     * @uses self::VALUE_HAZY
     * @uses self::VALUE_FOG
     * @uses self::VALUE_FOGPAT
     * @uses self::VALUE_GALE
     * @uses self::VALUE_STRM
     * @uses self::VALUE_HURRC
     * @uses self::VALUE_FZRA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLR,
            self::VALUE_CLDY,
            self::VALUE_OCST,
            self::VALUE_DZZL,
            self::VALUE_RAIN,
            self::VALUE_LRAIN,
            self::VALUE_ORAIN,
            self::VALUE_HRAIN,
            self::VALUE_SLEET,
            self::VALUE_SNOW,
            self::VALUE_SNFALL,
            self::VALUE_HAIL,
            self::VALUE_SHWRS,
            self::VALUE_THSTRM,
            self::VALUE_HAZY,
            self::VALUE_FOG,
            self::VALUE_FOGPAT,
            self::VALUE_GALE,
            self::VALUE_STRM,
            self::VALUE_HURRC,
            self::VALUE_FZRA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
