<?php

namespace EnumType;

/**
 * This class stands for type_code_enum EnumType
 * @subpackage Enumerations
 */
class Type_code_enum
{
    /**
     * Constant for value 'RIV'
     * @return string 'RIV'
     */
    const VALUE_RIV = 'RIV';
    /**
     * Constant for value 'CAN'
     * @return string 'CAN'
     */
    const VALUE_CAN = 'CAN';
    /**
     * Constant for value 'LAK'
     * @return string 'LAK'
     */
    const VALUE_LAK = 'LAK';
    /**
     * Constant for value 'FWY'
     * @return string 'FWY'
     */
    const VALUE_FWY = 'FWY';
    /**
     * Constant for value 'LCK'
     * @return string 'LCK'
     */
    const VALUE_LCK = 'LCK';
    /**
     * Constant for value 'BRI'
     * @return string 'BRI'
     */
    const VALUE_BRI = 'BRI';
    /**
     * Constant for value 'RMP'
     * @return string 'RMP'
     */
    const VALUE_RMP = 'RMP';
    /**
     * Constant for value 'BAR'
     * @return string 'BAR'
     */
    const VALUE_BAR = 'BAR';
    /**
     * Constant for value 'BNK'
     * @return string 'BNK'
     */
    const VALUE_BNK = 'BNK';
    /**
     * Constant for value 'GAU'
     * @return string 'GAU'
     */
    const VALUE_GAU = 'GAU';
    /**
     * Constant for value 'BUO'
     * @return string 'BUO'
     */
    const VALUE_BUO = 'BUO';
    /**
     * Constant for value 'BEA'
     * @return string 'BEA'
     */
    const VALUE_BEA = 'BEA';
    /**
     * Constant for value 'ANC'
     * @return string 'ANC'
     */
    const VALUE_ANC = 'ANC';
    /**
     * Constant for value 'BER'
     * @return string 'BER'
     */
    const VALUE_BER = 'BER';
    /**
     * Constant for value 'MOO'
     * @return string 'MOO'
     */
    const VALUE_MOO = 'MOO';
    /**
     * Constant for value 'TER'
     * @return string 'TER'
     */
    const VALUE_TER = 'TER';
    /**
     * Constant for value 'HAR'
     * @return string 'HAR'
     */
    const VALUE_HAR = 'HAR';
    /**
     * Constant for value 'FDO'
     * @return string 'FDO'
     */
    const VALUE_FDO = 'FDO';
    /**
     * Constant for value 'CAB'
     * @return string 'CAB'
     */
    const VALUE_CAB = 'CAB';
    /**
     * Constant for value 'FER'
     * @return string 'FER'
     */
    const VALUE_FER = 'FER';
    /**
     * Constant for value 'PIP'
     * @return string 'PIP'
     */
    const VALUE_PIP = 'PIP';
    /**
     * Constant for value 'PPO'
     * @return string 'PPO'
     */
    const VALUE_PPO = 'PPO';
    /**
     * Constant for value 'HFA'
     * @return string 'HFA'
     */
    const VALUE_HFA = 'HFA';
    /**
     * Constant for value 'HMO'
     * @return string 'HMO'
     */
    const VALUE_HMO = 'HMO';
    /**
     * Constant for value 'SHY'
     * @return string 'SHY'
     */
    const VALUE_SHY = 'SHY';
    /**
     * Constant for value 'REF'
     * @return string 'REF'
     */
    const VALUE_REF = 'REF';
    /**
     * Constant for value 'MAR'
     * @return string 'MAR'
     */
    const VALUE_MAR = 'MAR';
    /**
     * Constant for value 'LIG'
     * @return string 'LIG'
     */
    const VALUE_LIG = 'LIG';
    /**
     * Constant for value 'SIG'
     * @return string 'SIG'
     */
    const VALUE_SIG = 'SIG';
    /**
     * Constant for value 'TUR'
     * @return string 'TUR'
     */
    const VALUE_TUR = 'TUR';
    /**
     * Constant for value 'CBR'
     * @return string 'CBR'
     */
    const VALUE_CBR = 'CBR';
    /**
     * Constant for value 'TUN'
     * @return string 'TUN'
     */
    const VALUE_TUN = 'TUN';
    /**
     * Constant for value 'BCO'
     * @return string 'BCO'
     */
    const VALUE_BCO = 'BCO';
    /**
     * Constant for value 'REP'
     * @return string 'REP'
     */
    const VALUE_REP = 'REP';
    /**
     * Constant for value 'FLO'
     * @return string 'FLO'
     */
    const VALUE_FLO = 'FLO';
    /**
     * Constant for value 'SLI'
     * @return string 'SLI'
     */
    const VALUE_SLI = 'SLI';
    /**
     * Constant for value 'DUK'
     * @return string 'DUK'
     */
    const VALUE_DUK = 'DUK';
    /**
     * Constant for value 'VTC'
     * @return string 'VTC'
     */
    const VALUE_VTC = 'VTC';
    /**
     * Constant for value 'RES'
     * @return string 'RES'
     */
    const VALUE_RES = 'RES';
    /**
     * Constant for value 'LKB'
     * @return string 'LKB'
     */
    const VALUE_LKB = 'LKB';
    /**
     * Constant for value 'BRO'
     * @return string 'BRO'
     */
    const VALUE_BRO = 'BRO';
    /**
     * Constant for value 'BNS'
     * @return string 'BNS'
     */
    const VALUE_BNS = 'BNS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RIV
     * @uses self::VALUE_CAN
     * @uses self::VALUE_LAK
     * @uses self::VALUE_FWY
     * @uses self::VALUE_LCK
     * @uses self::VALUE_BRI
     * @uses self::VALUE_RMP
     * @uses self::VALUE_BAR
     * @uses self::VALUE_BNK
     * @uses self::VALUE_GAU
     * @uses self::VALUE_BUO
     * @uses self::VALUE_BEA
     * @uses self::VALUE_ANC
     * @uses self::VALUE_BER
     * @uses self::VALUE_MOO
     * @uses self::VALUE_TER
     * @uses self::VALUE_HAR
     * @uses self::VALUE_FDO
     * @uses self::VALUE_CAB
     * @uses self::VALUE_FER
     * @uses self::VALUE_PIP
     * @uses self::VALUE_PPO
     * @uses self::VALUE_HFA
     * @uses self::VALUE_HMO
     * @uses self::VALUE_SHY
     * @uses self::VALUE_REF
     * @uses self::VALUE_MAR
     * @uses self::VALUE_LIG
     * @uses self::VALUE_SIG
     * @uses self::VALUE_TUR
     * @uses self::VALUE_CBR
     * @uses self::VALUE_TUN
     * @uses self::VALUE_BCO
     * @uses self::VALUE_REP
     * @uses self::VALUE_FLO
     * @uses self::VALUE_SLI
     * @uses self::VALUE_DUK
     * @uses self::VALUE_VTC
     * @uses self::VALUE_RES
     * @uses self::VALUE_LKB
     * @uses self::VALUE_BRO
     * @uses self::VALUE_BNS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RIV,
            self::VALUE_CAN,
            self::VALUE_LAK,
            self::VALUE_FWY,
            self::VALUE_LCK,
            self::VALUE_BRI,
            self::VALUE_RMP,
            self::VALUE_BAR,
            self::VALUE_BNK,
            self::VALUE_GAU,
            self::VALUE_BUO,
            self::VALUE_BEA,
            self::VALUE_ANC,
            self::VALUE_BER,
            self::VALUE_MOO,
            self::VALUE_TER,
            self::VALUE_HAR,
            self::VALUE_FDO,
            self::VALUE_CAB,
            self::VALUE_FER,
            self::VALUE_PIP,
            self::VALUE_PPO,
            self::VALUE_HFA,
            self::VALUE_HMO,
            self::VALUE_SHY,
            self::VALUE_REF,
            self::VALUE_MAR,
            self::VALUE_LIG,
            self::VALUE_SIG,
            self::VALUE_TUR,
            self::VALUE_CBR,
            self::VALUE_TUN,
            self::VALUE_BCO,
            self::VALUE_REP,
            self::VALUE_FLO,
            self::VALUE_SLI,
            self::VALUE_DUK,
            self::VALUE_VTC,
            self::VALUE_RES,
            self::VALUE_LKB,
            self::VALUE_BRO,
            self::VALUE_BNS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
