<?php

namespace EnumType;

/**
 * This class stands for reference_code_enum EnumType
 * @subpackage Enumerations
 */
class Reference_code_enum
{
    /**
     * Constant for value 'NAP'
     * @return string 'NAP'
     */
    const VALUE_NAP = 'NAP';
    /**
     * Constant for value 'KP'
     * @return string 'KP'
     */
    const VALUE_KP = 'KP';
    /**
     * Constant for value 'FZP'
     * @return string 'FZP'
     */
    const VALUE_FZP = 'FZP';
    /**
     * Constant for value 'ADR'
     * @return string 'ADR'
     */
    const VALUE_ADR = 'ADR';
    /**
     * Constant for value 'TAW'
     * @return string 'TAW'
     */
    const VALUE_TAW = 'TAW';
    /**
     * Constant for value 'PUL'
     * @return string 'PUL'
     */
    const VALUE_PUL = 'PUL';
    /**
     * Constant for value 'NGM'
     * @return string 'NGM'
     */
    const VALUE_NGM = 'NGM';
    /**
     * Constant for value 'ETRS'
     * @return string 'ETRS'
     */
    const VALUE_ETRS = 'ETRS';
    /**
     * Constant for value 'POT'
     * @return string 'POT'
     */
    const VALUE_POT = 'POT';
    /**
     * Constant for value 'LDC'
     * @return string 'LDC'
     */
    const VALUE_LDC = 'LDC';
    /**
     * Constant for value 'HDC'
     * @return string 'HDC'
     */
    const VALUE_HDC = 'HDC';
    /**
     * Constant for value 'ZPG'
     * @return string 'ZPG'
     */
    const VALUE_ZPG = 'ZPG';
    /**
     * Constant for value 'GLW'
     * @return string 'GLW'
     */
    const VALUE_GLW = 'GLW';
    /**
     * Constant for value 'HSW'
     * @return string 'HSW'
     */
    const VALUE_HSW = 'HSW';
    /**
     * Constant for value 'LNW'
     * @return string 'LNW'
     */
    const VALUE_LNW = 'LNW';
    /**
     * Constant for value 'HNW'
     * @return string 'HNW'
     */
    const VALUE_HNW = 'HNW';
    /**
     * Constant for value 'IGN'
     * @return string 'IGN'
     */
    const VALUE_IGN = 'IGN';
    /**
     * Constant for value 'WGS'
     * @return string 'WGS'
     */
    const VALUE_WGS = 'WGS';
    /**
     * Constant for value 'RN'
     * @return string 'RN'
     */
    const VALUE_RN = 'RN';
    /**
     * Constant for value 'HBO'
     * @return string 'HBO'
     */
    const VALUE_HBO = 'HBO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NAP
     * @uses self::VALUE_KP
     * @uses self::VALUE_FZP
     * @uses self::VALUE_ADR
     * @uses self::VALUE_TAW
     * @uses self::VALUE_PUL
     * @uses self::VALUE_NGM
     * @uses self::VALUE_ETRS
     * @uses self::VALUE_POT
     * @uses self::VALUE_LDC
     * @uses self::VALUE_HDC
     * @uses self::VALUE_ZPG
     * @uses self::VALUE_GLW
     * @uses self::VALUE_HSW
     * @uses self::VALUE_LNW
     * @uses self::VALUE_HNW
     * @uses self::VALUE_IGN
     * @uses self::VALUE_WGS
     * @uses self::VALUE_RN
     * @uses self::VALUE_HBO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NAP,
            self::VALUE_KP,
            self::VALUE_FZP,
            self::VALUE_ADR,
            self::VALUE_TAW,
            self::VALUE_PUL,
            self::VALUE_NGM,
            self::VALUE_ETRS,
            self::VALUE_POT,
            self::VALUE_LDC,
            self::VALUE_HDC,
            self::VALUE_ZPG,
            self::VALUE_GLW,
            self::VALUE_HSW,
            self::VALUE_LNW,
            self::VALUE_HNW,
            self::VALUE_IGN,
            self::VALUE_WGS,
            self::VALUE_RN,
            self::VALUE_HBO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
